package com.geoway.design.biz.service.sys;

import cn.hutool.core.lang.tree.Tree;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysMenu;

import java.util.List;

/**
 * 菜单
 *
 * @author: wujing
 * @Date: 2021/11/11
 */
public interface INsMenuService extends IService<SysMenu> {

    /**
     * 保存与编辑
     *
     * @param menuSys
     * @throws Exception
     */
    void saveOrUp(SysMenu menuSys) throws Exception;

    /**
     * 查询
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryTree(String systemId, Integer flag, Integer group);

    /**
     * 删除
     *
     * @param id
     * @throws Exception
     */
    void deleteMenu(String id, String pid) throws Exception;

    /**
     * 排序置换
     *
     * @param flag
     * @param id
     * @param pid
     * @param systemId
     * @param sort
     * @throws Exception
     */
    void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception;

    /**
     * 根据id修改为功能菜单
     *
     * @param id
     */
    void updateType(String id, Integer type, String fid, Integer funType);

    /**
     * 设计默认菜单
     *
     * @param id
     */
    void updateDefault(String id, String sid);


    /**
     * 查询用户所属菜单树
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryUserMenuTree(String userId, String systemId, Integer flag, Integer group);

    /**
     * 获取菜单结构树
     *
     * @param roleIdList 角色id
     * @return {@link List}<{@link Tree}<{@link String}>>
     */
    List<Tree<String>> getSysMenuVoTree(List<String> roleIdList);

    SysMenu queryMenuByKey(String menuKey,String systemId);

}
