package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysPermissionSubfunction;
import com.geoway.design.biz.entity.SysSubFunction;
import com.geoway.design.biz.entity.SysSubFunctionGroup;

import java.util.List;

/**
 *
 */
public interface ISysPermissionSubfunctionService extends IService<SysPermissionSubfunction> {
    /**
     * 批量保存
     * @param permissionId
     * @param menuId
     * @param funIds
     */
    void batchSave(String permissionId,String menuId,List<String> funIds);


    /**
     * 查询菜单关联的子功能信息
     * @param permissionId
     * @param menuId
     */
    List<SysSubFunctionGroup> queryByPermissionId(String permissionId, String menuId);

    /**
     * 查询权限关联的子功能信息
     * @param permissionIds
     * @param menuId
     */
    List<SysSubFunction> querySubFunctionByPermissionIdList(List<String> permissionIds, String menuId);
}
