package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysRegion;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_region】的数据库操作Service
* @createDate 2022-01-20 15:42:06
*/
public interface ISysRegionService extends IService<SysRegion> {

    /**
     * 保存与编辑
     * @param
     * @throws Exception
     */
    void saveOrUp(SysRegion region) throws Exception;

    /**
     * 查询辖区的树状结构
     * @return
     */
    List<SysRegion> queryTree(String filterParam,String sortParam) throws Exception;

    /**
     * 根据过滤条件列表
     * @return
     */
    List<SysRegion> queryList(String filterParam,String sortParam) throws Exception;

    /**
     * 获取子辖区
     * @param regionCode
     * @return
     */
    List<SysRegion> queryRegionListByCode(String regionCode);

    /**
     * 获取上级辖区
     * @param regionCode
     * @return
     */
    List<SysRegion> queryAllParentRegion(String regionCode);

    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysRegion> queryPage(String filterParam, int page, int size) throws Exception;

    /**
     * 批量删除
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids);

    /**
     * 查询角色信息（含直属子节点）
     * @param id
     * @param filterParam
     * @return
     */
    SysRegion findOne(String id, String filterParam) throws Exception;

    /**
     * 注册行政区到辖区
     * @param rootRegionCode
     * @return
     */
    List<SysRegion> registerRegionByXzq(String rootRegionCode);

    /**
     * excel导入
     * @param stream
     */
    void excelImport(InputStream stream);

    /**
     * excel导出
     * @param outputStream
     * @param rootRegionCode
     */
    void excelOutput(OutputStream outputStream, String  rootRegionCode ) throws IOException;

    /**
     * 查询用户关联组织机构
     * @param userId
     * @return
     */
    List<SysRegion> queryUserRegions(String userId);

}
