package com.geoway.design.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.dto.UserRegistDTO;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.vo.SysUserVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author daidongdong
 * @description 针对表【sys_user】的数据库操作Service
 * @createDate 2021-12-20 17:06:21
 */

public interface ISysUserService  extends IService<SysUser>{

    /**
     * 保存与编辑
     *
     * @param
     * @throws Exception
     */
    void saveOrUp(SysUser user,MultipartFile file,boolean deletePhoto) throws Exception;

    /**
     * 批量保存用户
     */
    void batchSave(List<SysUser> users) throws Exception;


    /**
     * 根据过滤条件列表
     *
     * @return
     */
    List<SysUser> queryList(String filterParam) throws Exception;
    /**
     * 根据过滤条件列表
     * @param filterParam
     * @return
     * @throws Exception
     */
    List<SysUser> queryList(String filterParam,boolean withRoleOrg);
    /**
     * 查找单个用户
     * @param id
     * @return
     */
    SysUser queryOne(String id);

    /**
     * 批量查找用户
     * @param
     * @return
     */
    List<SysUser> queryByIds(List<String> ids);

    /**
     * 根据过滤条件查询分页
     *
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysUser> queryPage(String filterParam, int page, int size) throws Exception;


    /**
     * 删除用户（附带删除用户关联的角色，组织等）
     * @param id
     */
    void deleteOne(String id) throws Exception;
    /**
     * 批量删除
     *
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids) throws Exception;

    /**
     * 查询用户关联的角色
     *
     * @param userId
     * @return
     */
    List<SysRole> queryRelRoles(String userId);

    /**
     * 查询用户关联的机构
     *
     * @param userId
     * @return
     */
    List<SysOrganization> queryRelOrgs(String userId);


    /**
     * 查询用户关联的辖区
     *
     * @param userId
     * @return
     */
    List<SysRegion> queryRelRegions(String userId);

    /**
     * 修改用户密码
     *
     * @param userId
     * @param password
     */
    void changeUserPassword(String userId, String password);

    Boolean modifyPassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception;

    /**
     * 通过用户id得到用户信息
     *
     * @param userId 用户id
     * @return {@link SysUserVO}
     */
    SysUserVO getUserInfoByUserId(String userId);

    Boolean userRegistrer(UserRegistDTO userRegistDTO) throws Exception;

    /**
     * 导出用户
     *
     * @param response
     */

    void exportUsers(String filterParam,Boolean isTemplate, HttpServletResponse response) throws Exception;

    /**
     * 导入用户
     *
     * @param
     */
    String importUsers(List<SysUser> userList, Boolean isUpdateSupport) throws Exception;;

    /**
     * 权限更新
     * @param user
     */
    void updateRoles(SysUser user);

    /**
     * 根据过滤条件列表
     * @param filterParam
     * @return
     */
    Map<String,Object> queryCount(String filterParam) throws Exception;


    /**
     * 根据用户id修改用户密码
     * @param userId
     * @param oldPwd
     * @param newPwd
     * @throws Exception
     */
    void changePasswordByUserId(String userId, String oldPwd, String newPwd) throws Exception;


    /**
     * 查询角色关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryRolerUsers(String roleId);

    /**
     * 查询组织机构关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryOrgUsers(String roleId);

    /**
     * 查询无机构用户列表
     * @return
     */
    List<SysUser> queryAllNonOrgUsers();

    void encryptPhone(String phone);

    void decryptPhone(String encryptPhone);

    /**
     * 通过电话号码查找到唯一用户
     * @param tel
     * @return
     */
    SysUser queryOneByTel(String tel);
}
