package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysOplogMapper;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.SysOplogService;
import com.geoway.sso.client.rpc.SsoUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class SysOplogServiceImpl extends ServiceImpl<SysOplogMapper, SysOplog>
		implements SysOplogService {

	@Autowired
	NsSystemMapper nsSystemMapper;

	@Autowired
	SysMenuMapper sysMenuMapper;

	@Autowired
	IOauth2Service oauth2Service;

	@Override
	public List<SysOplog> findByFilterParam(String filterParam) throws Exception {
		MyBatisQueryMapperUtils<SysOplog> qum = new MyBatisQueryMapperUtils<>();
		QueryWrapper queryWrapper = qum.queryMapper(filterParam, SysOplog.class);

		return this.list(queryWrapper);
	}

	@Override
	public IPage<SysOplog> findPageByFilterParam(String filterParam, int page, int size) throws Exception {
		MyBatisQueryMapperUtils<SysOplog> qum = new MyBatisQueryMapperUtils<>();
		QueryWrapper queryWrapper = qum.queryMapper(filterParam, SysOplog.class);

		queryWrapper.orderByDesc("f_createtime");
		Page<SysOplog> pages = new Page<>(page, size);

		return this.page(pages,queryWrapper);
	}

	@Override
	public void addMenuOpLog(HttpServletRequest request, String systemKey, String menuId) {

		SsoUser sysUser = oauth2Service.queryCurrentSsoUser(request);
		if(sysUser == null){
			return;
		}

		SysNsSystem systemItem = this.queryNsSystemByKey(systemKey);
		if(systemItem == null){
			return;
		}

		List<SysMenu> menuTree = new ArrayList<>();
		buildMenuTree(menuId, menuTree);
		if(menuTree.size() == 0){
			return;
		}
		CollectionUtil.reverse(menuTree);

		String opMenuName = menuTree.stream().map(i ->i.getName()).collect(Collectors.joining(" ->"));
		String ip =  ServletUtil.getClientIP(request);

		String opName = String.format("%s: %s访问了系统菜单(%s)",systemItem.getName(),sysUser.getUserName(),opMenuName);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("systemId",systemItem.getId());
		jsonObject.put("systemName",systemItem.getName());
		jsonObject.put("menuId",menuId);
		jsonObject.put("menuName",opMenuName);

		SysOplog sysOplog = new SysOplog();
		sysOplog.setUserid(sysUser.getUserid());
		sysOplog.setUsername(sysUser.getUserName());
		sysOplog.setMethod("openMenu");
		sysOplog.setParam(jsonObject.toJSONString());
		sysOplog.setIp(ip);
		sysOplog.setName(opName);
		sysOplog.setDetail(opMenuName);
		sysOplog.setOptype("openMenu");
		sysOplog.setCreatetime(new Date());
		sysOplog.setSystemid(systemItem.getId());
		sysOplog.setAppid(systemItem.getAppKey());

		this.save(sysOplog);
	}

	private SysNsSystem queryNsSystemByKey(String key){
		LambdaQueryWrapper<SysNsSystem> queryWrapper = Wrappers.lambdaQuery();
		queryWrapper.eq(SysNsSystem::getKey,key);
		queryWrapper.last(" limit 1");

        return nsSystemMapper.selectOne(queryWrapper);
	}

	private void buildMenuTree(String menuId,List<SysMenu> menuTree){

		SysMenu sysMenu = sysMenuMapper.selectById(menuId);
		if(sysMenu == null){
			return;
		}
		menuTree.add(sysMenu);
		if(StrUtil.isNotBlank(sysMenu.getPid()) || "-1".equals(sysMenu.getPid())){
			 this.buildMenuTree(sysMenu.getPid(),menuTree);
		}
	}
}
