package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.*;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.ISysPermissionApplicationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 */
@Service
public class SysPermissionApplicationServiceImpl extends ServiceImpl<SysPermissionApplicationMapper, SysPermissonApplication>
    implements ISysPermissionApplicationService {

    @Autowired
    IApplicationSysService applicationSysService;
    @Autowired
    SysPermissionFunctionMapper sysPermissionFunctionMapper;
    @Autowired
    FunctionSysMapper functionSysMapper;

    @Override
    public List<SysApplication> queryByPermissionId(String permissionId) {
        LambdaQueryWrapper<SysPermissonApplication> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonApplication::getPermissionid, permissionId);
        List<SysPermissonApplication> roleSystems=this.list(wrapper);
        List<String> systemIds= roleSystems.stream().map(f->f.getApplicationid()).collect(Collectors.toList());
        if(systemIds.size()==0){
            return new ArrayList<>();
        }
        return applicationSysService.listByIds(systemIds);
    }

    @Override
    public void delete(String permissionId, String appId) {

        //查询系统关联的菜单信息并删除与权限的绑定
        LambdaQueryWrapper<SysFunction> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysFunction::getAppId,appId);
        List<SysFunction> sysFunctions = functionSysMapper.selectList(queryWrapper2);
        List<String> functionsIds = sysFunctions.stream().map( i -> i.getId()).collect(Collectors.toList());

        //删除权限系统关联的菜单信息
        if(functionsIds.size()>0){
            LambdaQueryWrapper<SysPermissionFunction> queryWrapper3 = Wrappers.lambdaQuery();
            queryWrapper3.eq(SysPermissionFunction::getPermissionid,permissionId);
            queryWrapper3.in(SysPermissionFunction::getFuncid,functionsIds);
            sysPermissionFunctionMapper.delete(queryWrapper3);
        }

        LambdaQueryWrapper<SysPermissonApplication> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonApplication::getPermissionid, permissionId).eq(SysPermissonApplication::getApplicationid,appId);
        this.remove(wrapper);
    }

    @Override
    public void batchDelete(String permissionId, List<String> systemIds) {
        for(String systemId:systemIds){
            this.delete(permissionId,systemId);
        }
    }

    @Override
    public void batchSave(String permissionId, List<String> applicationIds) {
        //先删除后增加
        LambdaQueryWrapper<SysPermissonApplication> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonApplication::getPermissionid, permissionId);
        this.remove(wrapper);

        List<SysPermissonApplication> applications=new ArrayList<>();
        applicationIds.forEach(f->{
            SysPermissonApplication sys=new SysPermissonApplication();
            sys.setPermissionid(permissionId);
            sys.setApplicationid(f);
            applications.add(sys);
        });
        this.saveBatch(applications);
    }
}




