package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysPermissionGroup;
import com.geoway.design.biz.mapper.SysPermissionGroupMapper;
import com.geoway.design.biz.service.sys.ISysPermissionGroupService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_permission_group】的数据库操作Service实现
* @createDate 2021-11-30 15:59:35
*/
@Service
public class SysPermissionGroupServiceImpl extends ServiceImpl<SysPermissionGroupMapper, SysPermissionGroup>
    implements ISysPermissionGroupService {

    @Autowired
    ISysPermissionService sysPermissionService;

    @Override
    public List<SysPermissionGroup> listByFilter(String filterParam, boolean hasChildren) throws Exception {

        if(filterParam == null){
            filterParam = "";
        }

        List<SysPermissionGroup>  allGroups = this.list();
        MyBatisQueryMapperUtils<SysPermissionGroup> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysPermissionGroup.class);
        List<SysPermissionGroup>  groups = this.list(queryWrapper);

        List<String> filterGroupIds = groups.stream().map(x -> x.getId()).collect(Collectors.toList());

        if(hasChildren){
            MyBatisQueryMapperUtils<SysPermission> qmuChild = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapperChild = qmuChild.queryMapper(filterParam, SysPermission.class);
            List<SysPermission>  childrens = sysPermissionService.list(queryWrapperChild);
            groups = this.buildTree(filterGroupIds, allGroups, childrens);
        }

        return groups;
    }

    @Override
    public void batchDelete(String ids) {
        if(StrUtil.isBlank(ids)){
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        this.removeByIds(idList);
    }

    private  void insertChildNodes(List<SysPermissionGroup> groups, List<SysPermission> childrens){
        for(SysPermissionGroup group: groups){
            List<SysPermission> filterList = childrens.stream().filter(u -> u.getGroupid().equals(group.getId())).collect(Collectors.toList());
            group.setChildren(filterList);
        }
    }

    private List<SysPermissionGroup> buildTree(List<String> filterGroupIds,List<SysPermissionGroup> allGroups, List<SysPermission> childrens){
        List<SysPermissionGroup> results = new ArrayList<>();
        boolean flag = false;
        for(SysPermissionGroup group: allGroups){
            List<SysPermission> filterList = childrens.stream().filter(u -> u.getGroupid().equals(group.getId())).collect(Collectors.toList());
            group.setChildren(filterList);
            flag = filterList.size() > 0 || filterGroupIds.contains(group.getId());
            if(flag){
                results.add(group);
            }
        }

        return  results;
    }
}




