package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.SysPermissionMapper;
import com.geoway.design.biz.mapper.SysRolePermissionMapper;
import com.geoway.design.biz.service.sys.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_permission】的数据库操作Service实现
* @createDate 2021-11-30 15:54:36
*/
@Service
public class SysPermissionServiceImpl extends ServiceImpl<SysPermissionMapper, SysPermission>
    implements ISysPermissionService {

    @Autowired
    ISysPermissionMenuService sysPermissionMenuService;

    @Autowired
    INsMenuService menuService;

    @Autowired
    ISysPermissionSystemService sysPermissionSystemService;

    @Autowired
    SysRolePermissionMapper sysRolePermissionMapper;

    @Autowired
    INsSystemService nsSystemService;

    @Autowired
    IFunctionSysService functionSysService;

    @Autowired
    ISysPermissionFunctionService sysPermissionFunctionService;

    @Override
    public void saveOrUp(SysPermission permission) throws Exception {
        //判断名称是否重复
        LambdaQueryWrapper<SysPermission> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermission::getGroupid, permission.getGroupid());
        wrapper.eq(SysPermission::getName,permission.getName());
        //有id就是更新
        if(StrUtil.isNotBlank(permission.getId())) {
            wrapper.ne(SysPermission::getId, permission.getId());
        }

        int iCount = this.count(wrapper);
        if(iCount > 0){
            throw new Exception("权限名称: "+ permission.getName()+"  已存在！");
        }
        this.saveOrUpdate(permission);
    }

    @Override
    public void saveRelateSystems(String permissonId, List<String> systemIds) {
        sysPermissionSystemService.batchSave(permissonId,systemIds);
    }

    @Override
    public IPage<SysPermission> queryByFilter(String params, Integer page, Integer size) throws Exception {

        if(StringUtils.isBlank(params)){
            Page<SysPermission> pages = new Page<>();
            return this.page(pages);
        }

        MyBatisQueryMapperUtils<SysApplication> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysPermission.class);
        Page<SysPermission> pages = new Page<>(page,size);

        return this.page(pages,queryWrapper);
    }

    @Override
    public List<SysMenu> queryRelateMenus(String id,String systemId) {

        LambdaQueryWrapper<SysPermissionMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionMenu::getPermissionid, id);
        List<SysPermissionMenu> permissionMenus = sysPermissionMenuService.list(wrapper);
        List<String>  menuIds = permissionMenus.stream().map(x -> x.getMenuid()).collect(Collectors.toList());
        if(menuIds.size() == 0){
            return  new ArrayList<SysMenu>();
        }

        LambdaQueryWrapper<SysMenu> sysMenuWrapper = Wrappers.lambdaQuery();
        sysMenuWrapper.eq(SysMenu::getSystemId,systemId).in(SysMenu::getId,menuIds);
        return menuService.list(sysMenuWrapper);
    }

    @Override
    public void saveRelateMenus(String permissonId,String systemId, List<String> menuIds) {

        //先清除，再添加
        LambdaQueryWrapper<SysMenu> sysMenuWrapper = Wrappers.lambdaQuery();
        sysMenuWrapper.eq(SysMenu::getSystemId,systemId);
        List<SysMenu> wholeMenus=menuService.list(sysMenuWrapper);

        LambdaQueryWrapper<SysPermissionMenu> permissionMenuWrapper = Wrappers.lambdaQuery();
        permissionMenuWrapper.eq(SysPermissionMenu::getPermissionid, permissonId).in(SysPermissionMenu::getMenuid,wholeMenus.stream().map(f->f.getId()).collect(Collectors.toList()));
        sysPermissionMenuService.remove(permissionMenuWrapper);

        SysPermissionMenu permissionMenu = null;
        for(String menuId: menuIds){
            permissionMenu = new SysPermissionMenu();
            permissionMenu.setPermissionid(permissonId);
            permissionMenu.setMenuid(menuId);
            sysPermissionMenuService.save(permissionMenu);
        }
    }

    @Override
    public void saveRelateFunctions(String permissonId, String applicationId, List<String> functionIds) {
        //先清除，再添加
        LambdaQueryWrapper<SysFunction> sysFuncWrapper = Wrappers.lambdaQuery();
        sysFuncWrapper.eq(SysFunction::getAppId,applicationId);
        List<SysFunction> wholeFuncs=functionSysService.list(sysFuncWrapper);

        LambdaQueryWrapper<SysPermissionFunction> permissionFuncWrapper = Wrappers.lambdaQuery();
        permissionFuncWrapper.eq(SysPermissionFunction::getPermissionid, permissonId).in(SysPermissionFunction::getFuncid,wholeFuncs.stream().map(f->f.getId()).collect(Collectors.toList()));
        sysPermissionFunctionService.remove(permissionFuncWrapper);

        SysPermissionFunction permissionFunc = null;
        for(String FuncId: functionIds){
            permissionFunc = new SysPermissionFunction();
            permissionFunc.setPermissionid(permissonId);
            permissionFunc.setFuncid(FuncId);
            sysPermissionFunctionService.save(permissionFunc);
        }
    }

    @Override
    public List<SysFunction> queryRelateFunctions(String id, String applicationId) {
        LambdaQueryWrapper<SysPermissionFunction> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissionFunction::getPermissionid, id);
        List<SysPermissionFunction> permissionMenus = sysPermissionFunctionService.list(wrapper);
        List<String>  funcIds = permissionMenus.stream().map(x -> x.getFuncid()).collect(Collectors.toList());
        if(funcIds.size() == 0){
            return  new ArrayList<>();
        }

        LambdaQueryWrapper<SysFunction> sysMenuWrapper = Wrappers.lambdaQuery();
        sysMenuWrapper.eq(SysFunction::getAppId,applicationId).in(SysFunction::getId,funcIds);
        return functionSysService.list(sysMenuWrapper);
    }

    @Override
    public void delete(String id) throws Exception {

        LambdaQueryWrapper<SysRolePermission> queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysRolePermission::getPermissionid, id);
        int iCount = sysRolePermissionMapper.selectCount(queryWrapper1);
        if(iCount > 0){
            throw  new Exception("角色下存在该权限，不能删除");
        }

        LambdaQueryWrapper<SysPermissionMenu> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysPermissionMenu::getPermissionid, id);
        sysPermissionMenuService.remove(queryWrapper2);

        LambdaQueryWrapper<SysPermissonSystem> queryWrapper3 = Wrappers.lambdaQuery();
        queryWrapper3.eq(SysPermissonSystem::getPermissionid, id);
        sysPermissionSystemService.remove(queryWrapper3);

        this.removeById(id);
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if(StrUtil.isBlank(ids)){
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for(String id: idList){
            this.delete(id);
        }

    }

    @Override
    public List<SysPermission> queryRolePermissons(String roleIds) {
        List<String> roleIdList = new ArrayList<>();
        if(StrUtil.isNotBlank(roleIds)){
            roleIdList = Arrays.asList(roleIds.split(","));
        }
        return  this.baseMapper.queryRolePermissons(roleIdList);
    }

    @Override
    public List<SysPermission> queryRolePermissons(List<String> roleIds) {
        return  this.baseMapper.queryRolePermissons(roleIds);
    }

    @Override
    public boolean saveBatch(Collection<SysPermission> entityList) {
        return super.saveBatch(entityList);
    }
}




