package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysXzqRegion;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysXzqRegionService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;

/**
 * @author daidongdong
 * @description 针对表【sys_region】的数据库操作Service实现
 * @createDate 2022-01-20 15:42:06
 */
@Service
public class SysRegionServiceImpl extends ServiceImpl<SysRegionMapper, SysRegion>
        implements ISysRegionService {

    @Autowired
    ISysXzqRegionService sysXzqRegionService;

    @Override
    public void saveOrUp(SysRegion region) throws Exception {

        if (StrUtil.isBlank(region.getCode())) {
            region.setCode(region.getRegionCode());
        }

        if (StrUtil.isBlank(region.getRegionCode())) {
            region.setRegionCode(region.getCode());
        }

        //判断名称是否重复
        LambdaQueryWrapper<SysRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRegion::getCode, region.getCode());
        //有id就是更新
        if (StrUtil.isNotBlank(region.getId())) {
            wrapper.ne(SysRegion::getId, region.getId());
        }
        int iCount = this.count(wrapper);
        if (iCount > 0) {
            throw new Exception("辖区编码已存在");
        }

        wrapper.clear();
        wrapper.eq(SysRegion::getCode, region.getPcode());
        wrapper.last(" limit 1 ");

        SysRegion pRegion = this.getOne(wrapper);
        int level = pRegion == null ? 1 : pRegion.getLevel() + 1;
        region.setLevel(level);

        this.saveOrUpdate(region);

    }

    @Override
    public List<SysRegion> queryTree(String filterParam, String sortParam) throws Exception {
        List<SysRegion> regions = this.queryList(filterParam, sortParam);
        return constructTree(regions);
    }

    @Override
    public List<SysRegion> queryList(String filterParam, String sortParam) throws Exception {
        MyBatisQueryMapperUtils<SysRegion> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysRegion.class);
        List<SysRegion> regions = this.list(queryWrapper);
        return regions;
    }

    @Override
    public List<SysRegion> queryRegionListByCode(String regionCode){
        List<SysRegion> children = this.baseMapper.getRegionListByCode(regionCode);
        Collections.reverse(children);
        return children;
    }

    @Override
    public List<SysRegion> queryAllParentRegion(String regionCode) {
        List<SysRegion> result = this.baseMapper.getAllParentRegion(regionCode);
        Collections.reverse(result);
        return result;
    }

    @Override
    public IPage<SysRegion> queryPage(String filterParam, int page, int size) throws Exception {

        MyBatisQueryMapperUtils<SysRegion> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRegion.class);
        Page<SysRegion> pages = new Page<>(page, size);

        return this.page(pages, queryWrapper);
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteTree(id);
        }
    }

    @Override
    public SysRegion findOne(String id, String filterParam) throws Exception {
        SysRegion region = this.getById(id);
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam += ";pcode_EQ_" + region.getCode();
        List<SysRegion> childrens = this.queryList(filterParam, "SORT_code_ASC");
        region.setChildren(childrens);

        return region;
    }


    @Override
    public List<SysRegion> registerRegionByXzq(String rootRegionCode) {

        LambdaQueryWrapper<SysXzqRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysXzqRegion::getCode, rootRegionCode);
        SysXzqRegion rootRegion = sysXzqRegionService.getOne(wrapper);

        String matchCode = rootRegionCode;
        if (rootRegion.getLevel() == 1) {
            matchCode = rootRegionCode.substring(0, 2);
        } else if (rootRegion.getLevel() == 2) {
            matchCode = rootRegionCode.substring(0, 4);
        } else if (rootRegion.getLevel() == 3) {
            matchCode = rootRegionCode.substring(0, 6);
        } else if (rootRegion.getLevel() == 4) {
            matchCode = rootRegionCode.substring(0, 9);
        }

        wrapper.clear();
        wrapper.likeRight(SysXzqRegion::getCode, matchCode);
        wrapper.orderByAsc(SysXzqRegion::getCode, SysXzqRegion::getLevel);

        List<SysXzqRegion> xzqRegions = sysXzqRegionService.list(wrapper);

        LambdaQueryWrapper<SysRegion> wrapper2 = Wrappers.lambdaQuery();
        wrapper2.likeRight(SysRegion::getCode, matchCode);
        this.remove(wrapper2);

        SysRegion region = null;
        List<SysRegion> regions = new ArrayList<>();
        int minusLevel = rootRegion.getLevel();
        for (SysXzqRegion xzqRegion : xzqRegions) {
            region = new SysRegion();
            BeanUtils.copyProperties(xzqRegion, region);
            region.setRegionCode(xzqRegion.getCode());
            int level = xzqRegion.getLevel() - minusLevel + 1;
            region.setLevel(level);

            regions.add(region);
        }

        this.saveBatch(regions);

        return this.constructTree(regions);
    }

    @Override
    public void excelOutput(OutputStream outputStream, String rootRegionCode) throws IOException {
        ExcelWriter excelWriter = null;
        try {
            LambdaQueryWrapper<SysXzqRegion> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysXzqRegion::getCode, rootRegionCode);
            SysXzqRegion rootRegion = sysXzqRegionService.getOne(wrapper);
            String matchCode = rootRegionCode;
            if (rootRegion.getLevel() == 1) {
                matchCode = rootRegionCode.substring(0, 2);
            } else if (rootRegion.getLevel() == 2) {
                matchCode = rootRegionCode.substring(0, 4);
            } else if (rootRegion.getLevel() == 3) {
                matchCode = rootRegionCode.substring(0, 6);
            } else if (rootRegion.getLevel() == 4) {
                matchCode = rootRegionCode.substring(0, 8);
            }

            wrapper.clear();
            wrapper.likeRight(SysXzqRegion::getCode, matchCode);
            wrapper.orderByAsc(SysXzqRegion::getCode, SysXzqRegion::getLevel);
            List<SysXzqRegion> xzqRegions = sysXzqRegionService.list(wrapper);
            List<Map<String, Object>> excelObjects = new ArrayList<>();
            //行政区名称、行政区代码、行政区级别
            for (SysXzqRegion sysXzqRegion : xzqRegions) {
                Map<String, Object> excelObject = new LinkedHashMap<>();
                excelObject.put("行政区名称", sysXzqRegion.getName());
                excelObject.put("行政区代码", sysXzqRegion.getCode());
                excelObject.put("父级行政区代码", sysXzqRegion.getPcode());
                if (sysXzqRegion.getLevel() == 1) {
                    excelObject.put("行政区级别", "省");
                } else if (sysXzqRegion.getLevel() == 2) {
                    excelObject.put("行政区级别", "市");
                } else if (sysXzqRegion.getLevel() == 3) {
                    excelObject.put("行政区级别", "县");
                } else if (sysXzqRegion.getLevel() == 4) {
                    excelObject.put("行政区级别", "乡镇");
                } else if (sysXzqRegion.getLevel() == 5) {
                    excelObject.put("行政区级别", "村");
                }

                excelObjects.add(excelObject);
                //excelObject.put("拼音",sysXzqRegion.getPinyin());
            }
            excelWriter = ExcelUtil.getWriter();
            excelWriter.write(excelObjects);
            excelWriter.flush(outputStream, true);

        } catch (Exception ex) {
            log.error(DateUtil.now() + " 辖区导出，Excel异常：" + ex.getMessage());
        } finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }

    }

    @Override
    public List<SysRegion> queryUserRegions(String userId) {
        return this.baseMapper.queryUserRegions(userId);
    }

    @Override
    public void excelImport(InputStream stream) {
        try {

            ExcelReader excelReader = ExcelUtil.getReader(stream, 0);
            List<List<Object>> excelList = excelReader.read(1);
            List<SysXzqRegion> sysRegionList = new ArrayList<>();
            //行政区名称、行政区代码、行政区级别
            for (List<Object> excelObject : excelList) {
                SysXzqRegion sysRegion = new SysXzqRegion();
                String name = excelObject.get(0).toString();
                String code = excelObject.get(1).toString();
                String pCode = excelObject.get(2).toString();
                String level = excelObject.get(3).toString();

                sysRegion.setName(name);
                sysRegion.setCode(code);
                switch (level) {
                    case "省":
                        sysRegion.setLevel(1);
                        break;
                    case "市":
                        sysRegion.setLevel(2);
                        break;
                    case "县":
                        sysRegion.setLevel(3);
                        break;
                    case "乡镇":
                        sysRegion.setLevel(4);
                        break;
                    case "村":
                        sysRegion.setLevel(5);
                        break;
                    default:
                        throw new RuntimeException("行政区划级别设置有误！");
                }
                sysRegion.setPcode(pCode);
                //sysRegion.setPinyin(excelObject.get(3).toString());
                sysRegionList.add(sysRegion);
            }
            for (SysXzqRegion sysXzqRegion : sysRegionList) {
                sysXzqRegionService.saveOrUpdate(sysXzqRegion, Wrappers.lambdaQuery(SysXzqRegion.class).eq(SysXzqRegion::getCode, sysXzqRegion.getCode()));
            }
            Collections.sort(sysRegionList, (o1, o2) -> {
                return o1.getLevel() - o2.getLevel();
            });
            registerRegionByXzq(sysRegionList.get(0).getCode());
        } catch (Exception ex) {
            throw new RuntimeException("导入行政区划失败");
        }
    }

    private String getPCode(String level, String code) {
        String parentCode = "";
        switch (level) {
            case "省":
                return "-1";
            case "市":
                parentCode = code.substring(0, 2);
                parentCode = parentCode + StrUtil.repeat('0', code.length() - 2);
                break;
            case "县":
                parentCode = code.substring(0, 4);
                parentCode = parentCode + StrUtil.repeat('0', code.length() - 4);
                break;
            case "乡镇":
                parentCode = code.substring(0, 6);
                parentCode = parentCode + StrUtil.repeat('0', code.length() - 6);
                break;
            case "村":
                parentCode = code.substring(0, 8);
                parentCode = parentCode + StrUtil.repeat('0', code.length() - 9);
                break;
            default:
                throw new RuntimeException("行政区划级别设置有误！");
        }
        return parentCode;
    }


    private void deleteTree(String id) {
        SysRegion region = this.getById(id);
        if (region == null || StrUtil.isBlank(region.getCode())) {
            return;
        }
        String rootRegionCode = region.getCode();
        String matchCode = rootRegionCode;
        if (region.getLevel() == 1) {
            matchCode = rootRegionCode.substring(0, 2);
        } else if (region.getLevel() == 2) {
            matchCode = rootRegionCode.substring(0, 4);
        } else if (region.getLevel() == 3) {
            matchCode = rootRegionCode.substring(0, 6);
        } else if (region.getLevel() == 4) {
            matchCode = rootRegionCode.substring(0, 9);
        }

        LambdaQueryWrapper<SysRegion> wrapper = Wrappers.lambdaQuery();
        wrapper.likeRight(SysRegion::getCode, matchCode);

        this.remove(wrapper);

    }

    /**
     * 递归查询树
     *
     * @param list
     * @return
     */
    private List<SysRegion> constructTree(List<SysRegion> list) {

        int minLevel = 9;
        Map<String, List<SysRegion>> mapParam = new HashMap<>();
        for (SysRegion region : list) {
            String key = region.getPcode();
            if (!StringUtils.isEmpty(key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(region);
                } else {
                    List<SysRegion> childList = new ArrayList<>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }

            if (region.getLevel() < minLevel) {
                minLevel = region.getLevel();
            }
        }
        List<SysRegion> results = new ArrayList<>();
        for (SysRegion region : list) {
            String key = region.getCode();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                region.setChildren(mapParam.get(key));
            }
            if (region.getLevel() == minLevel) {
                results.add(region);
            }
        }

        return results;
    }
}




