package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.mapper.SysRoleMapper;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRolePermissionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_role】的数据库操作Service实现
* @createDate 2021-11-26 17:00:03
*/
@Service
public class SysRoleServiceImpl extends ServiceImpl<SysRoleMapper, SysRole>
    implements ISysRoleService {

    @Autowired
    ISysRolePermissionService sysRolePermissionService;

    @Autowired
    ISysPermissionService sysPermissionService;
    @Autowired
    private IUserService userService;
    //@Autowired
    //SysUserMapper sysUserMapper;


    @Autowired
    SysOrganizationMapper sysOrganizationMapper;

    @Autowired
    ISysUserRoleService sysUserRoleService;

    @Override
    public void saveOrUp(SysRole role) throws Exception {

        //判断名称是否重复
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName,role.getName());
        wrapper.eq(SysRole::getPid,role.getPid());
        //有id就是更新
        if(StrUtil.isNotBlank(role.getId())){
            wrapper.ne(SysRole::getId, role.getId());

            SysRole oldRole = this.getById(role.getId());
            if(oldRole != null){
                role.setCreateTime(oldRole.getCreateTime());
                role.setParents(oldRole.getParents());
                role.setLevel(oldRole.getLevel());
                role.setSort(oldRole.getSort());
            }
            if(!oldRole.getName().equals(role.getName())){
               this.buildChildALlName(role);
            }
        }else{
            SysRole pRole = this.getById(role.getPid());
            int level = pRole == null ? 1: pRole.getLevel() + 1;
            role.setLevel(level);

            LambdaQueryWrapper<SysRole> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysRole::getPid, role.getPid());
            queryWrapper.orderByDesc(SysRole::getSort);
            queryWrapper.last(" limit 1");
            SysRole lastRole = this.getOne(queryWrapper);
            if(lastRole == null){
                role.setSort(1);
            }else{
                role.setSort(lastRole.getSort()+1);
            }

            String parents = "";
            if( pRole != null){
                parents = StrUtil.isNotBlank(pRole.getParents()) ? pRole.getId(): pRole.getParents() + "/" + pRole.getId();
            }
            role.setParents(parents);
        }
        int iCount = this.count(wrapper);
        if(iCount > 0){
            throw new Exception("角色【"+ role.getName()+"】已存在！");
        }
        this.buildAllName(role);
        this.saveOrUpdate(role);
    }

    @Override
    public List<SysRole> queryTree(String filterParam) throws Exception {
        //获取所有分类
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getType, 0);
        wrapper.orderByAsc(SysRole::getSort);
        List<SysRole> list = this.list(wrapper);

        //获取所有角色
        filterParam +=";type_EQ_1";
        MyBatisQueryMapperUtils<SysRole> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.orderByAsc("f_sort");
        List<SysRole>  roleList = this.list(queryWrapper);

        list.addAll(roleList);

        return constructTree(list);
    }

    @Override
    public List<SysRole> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils<SysRole> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.orderByAsc("f_sort");
        List<SysRole>  roleList = this.list(queryWrapper);

        return  roleList;
    }

    @Override
    public List<SysRole> queryAllParentRole(String id) {
        List<SysRole> roles = this.baseMapper.getAllParentRole(id);
        Collections.reverse(roles);
        return roles;
    }

    @Override
    public IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils<SysRole> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
        queryWrapper.orderByAsc("f_sort");
        Page<SysRole> pages = new Page<>(page,size);

        return  this.page(pages,queryWrapper);
    }

    @Override
    public List<SysPermission> queryPermissionByRoleId(String roleId) {
        LambdaQueryWrapper<SysRolePermission> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRolePermission::getRoleid, roleId);
        List<SysRolePermission> relObjs = sysRolePermissionService.list(wrapper);
        List<String>  relIds = relObjs.stream().map(x -> x.getPermissionid()).collect(Collectors.toList());
        if(relIds.size() == 0){
            return  new ArrayList<SysPermission>();
        }
        List<SysPermission> permissions = sysPermissionService.listByIds(relIds);

        return  permissions;
    }

    @Override
    public void saveRolePermissions(String roleId, String permissionIds) {
        LambdaQueryWrapper<SysRolePermission> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRolePermission::getRoleid, roleId);

        sysRolePermissionService.remove(wrapper);
        if(StrUtil.isBlank(permissionIds)){
            return;
        }
        String[] permissionIdArr =  permissionIds.split(",");
        List<SysRolePermission> rolePermissions = new ArrayList<SysRolePermission>();
        List<String> permissionIdList = new ArrayList<>();
        for(String permissionId: permissionIdArr){
            if(permissionIdList.contains(permissionId)){
                continue;
            }
            SysRolePermission rolePermission = new SysRolePermission();
            rolePermission.setPermissionid(permissionId);
            rolePermission.setRoleid(roleId);
            rolePermissions.add(rolePermission);

            permissionIdList.add(permissionId);

        }
        sysRolePermissionService.saveBatch(rolePermissions);
    }

    @Override
    public SysRole findOne(String id, String filterParam) throws Exception {
        SysRole role = this.getById(id);

        if(filterParam == null){
            filterParam = "";
        }
        //如果是类型节点
        if(role.getType() == 0){
            filterParam += ";pid_EQ_" + id;
            MyBatisQueryMapperUtils<SysRole> qmu = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);
            queryWrapper.orderByAsc("f_sort");
            List<SysRole> childRoles = this.list(queryWrapper);
            if(role != null){
                role.setChildren(childRoles);
            }
        }

        return role;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if(StrUtil.isBlank(ids)){
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for(String id: idList){
            this.deleteById(id);
        }
    }

    @Override
    public List<SysUser> queryRelUsers(String roleId) {
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, roleId);
        List<SysUserRole> userRoles=sysUserRoleService.list(wrapper);
        if(userRoles==null||userRoles.size()==0){
            return null;
        }
        List<SysUser> users =userService.query(userRoles.stream().map(f->f.getUserid()).collect(Collectors.toList()));
        this.wrapperOrgAllNames(users);
        return users;
    }

    @Override
    public List<SysRole> queryUserRoles(String userId) {
       return this.baseMapper.queryUserRoles(userId);
    }

    @Override
    public void sortRoles(String id, String pid, int flag) {

        List<SysRole> roles =  this.initSort(pid);
        int iCount = roles.size();
        if(iCount < 2){
            return;
        }
        int index = roles.stream().map( i -> i.getId()).collect(Collectors.toList()).indexOf(id);
        if(index < 0){
            return;
        }

        SysRole curRole = roles.get(index);
        List<SysRole> otherRoles =  roles.stream().filter(item -> !item.getId().equals(id)).collect(Collectors.toList());
        switch (flag) {
                //置顶
                case 1:
                    int start = 2;
                   curRole.setSort(1);
                   for(SysRole role: otherRoles){
                       role.setSort(start);
                       start++;
                   }
                   otherRoles.add(curRole);
                   this.updateBatchById(roles);
                   break;
                //上移
                case 2:
                    if(index > 0){
                      SysRole changRole = roles.get(index - 1);
                      int iSort = changRole.getSort();
                      changRole.setSort(curRole.getSort());
                      curRole.setSort(iSort);

                      this.updateById(curRole);
                      this.updateById(changRole);
                    }

                    break;
                //下移
                case 3:
                    //查询排序大一位的记录
                    if(index < iCount-1){
                        SysRole changRole = roles.get(index + 1);
                        int iSort = changRole.getSort();
                        changRole.setSort(curRole.getSort());
                        curRole.setSort(iSort);

                        this.updateById(curRole);
                        this.updateById(changRole);
                    }

                    break;
                //置底
                case 4:

                    int start2 = 1;
                    for(SysRole role: otherRoles){
                        role.setSort(start2);
                        start2++;
                    }
                    curRole.setSort(start2);
                    otherRoles.add(curRole);
                    this.updateBatchById(roles);
                    break;
                default:
                    break;
            }
    }

    @Override
    public List<SysRole> initSort(String pid) {

        LambdaQueryWrapper<SysRole> queryWrapper = Wrappers.lambdaQuery();
        if(pid == null){
            queryWrapper.isNull(SysRole::getPid);
        }else{
            queryWrapper.eq(SysRole::getPid,pid);
        }
        queryWrapper.orderByAsc(SysRole::getSort);

        List<SysRole> roles = this.list(queryWrapper);
        int iCount = roles.size();
        if(iCount < 2){
            return roles;
        }
        LambdaQueryWrapper<SysRole> queryWrapper2 = Wrappers.lambdaQuery();
        if(pid == null){
            queryWrapper2.isNull(SysRole::getPid);
        }else{
            queryWrapper2.eq(SysRole::getPid,pid);
        }
        queryWrapper2.groupBy(SysRole::getSort);
        queryWrapper2.select(SysRole::getSort);

        List  list2 = this.listMaps(queryWrapper2);
        int iCount2 = list2.size();

        if(iCount > iCount2) {
            for (int i = 0; i < roles.size(); i++) {
                SysRole role = roles.get(i);
                role.setSort(i + 1);
            }
            this.updateBatchById(roles);
        }

        return roles;
    }

    @Override
    public void dragRoleNode(String id, String refId, String type) throws Exception {
        SysRole role = this.getById(id);
        SysRole refRole = this.getById(refId);
        String pid = refRole.getPid();
        int sort = refRole.getSort();
        role.setLevel(refRole.getLevel());
        role.setParents(refRole.getParents());
        if(type.equals("inner")){
            pid = refRole.getId();
            role.setLevel(refRole.getLevel() + 1);
            role.setParents( refRole.getParents()+ "/" + refRole.getId());
        }
        role.setPid(pid);
        role.setSort(sort);


        this.buildAllName(role);
        this.saveOrUpdate(role);

        //重新排序
        this.initSort(pid);

        //默认上移
        int sortType = 2;
        if(type.equals("after")){
            sortType = 3;
        }else if(type.equals("inner")){
            sortType = 4;
        }

        this.sortRoles(id,pid,sortType);
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        int count = 0;
        MyBatisQueryMapperUtils<SysRole> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRole.class);

        count = this.count(queryWrapper);

        return count;
    }

    private void deleteById(String id) throws Exception{
        SysRole role = this.getById(id);
        //如果是角色
        if(role.getType() == 1){
            LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getRoleid, id);
            int iCount = sysUserRoleService.count(wrapper);
            if(iCount > 0){
                throw  new Exception("该角色下已关联用户，不能删除!");
            }

            LambdaQueryWrapper<SysRolePermission> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.eq(SysRolePermission::getRoleid,id);

            sysRolePermissionService.remove(wrapper2);
        }else{
            //如果是角色分组，则先删除下面的子节点
            LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRole::getPid,id);

            List<SysRole> subRoles = this.list(wrapper);
            for(SysRole subRole: subRoles){
                this.deleteById(subRole.getId());
            }
        }

        this.removeById(id);
    }


    /**
     * 递归查询树
     * @param list
     * @return
     */
    private List<SysRole> constructTree(List<SysRole>  list){

        int minLevel = 99;
        Map<String, List<SysRole>> mapParam = new HashMap<String, List<SysRole>>();
        for (SysRole role : list) {
            String key = role.getPid();
            if (!StringUtils.isEmpty(key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(role);
                } else {
                    List<SysRole> childList = new ArrayList<SysRole>();
                    childList.add(role);
                    mapParam.put(key, childList);
                }
            }

            if (role.getLevel() < minLevel) {
                minLevel = role.getLevel();
            }
        }
        List<SysRole> results = new ArrayList<SysRole>();
        for (SysRole role : list) {
            String key = role.getId();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                role.setChildren(mapParam.get(key));
            }
            if (role.getLevel() == minLevel) {
                results.add(role);
            }
        }

        return results;
    }

    private void buildChildALlName(SysRole role){
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
        wrapper.like(SysRole::getParents, role.getId());

        List<SysRole> roles = this.list(wrapper);
        for(SysRole subRole: roles){
            this.buildAllName(subRole);
        }

    }

    private void buildAllName(SysRole role){
        String parents = role.getParents();
        if(StrUtil.isBlank(parents)){
            role.setAllname(role.getName());
        }else{
            List<String> pRoleIds = Arrays.asList(parents.split("/"));
            List<SysRole> pRoles = this.baseMapper.selectBatchIds(pRoleIds);
            String allName = "";
            for(SysRole pRole: pRoles){
                allName += pRole.getName() + "/";
            }
            allName += role.getName();
            role.setAllname(allName);
        }

    }

    private void wrapperOrgAllNames(List<SysUser>  users ){
        Map<String,String> allNameCache = new HashMap<>();
        for(SysUser user: users){
            List<SysOrganization>  orgs = sysOrganizationMapper.queryUserOrgs(user.getId());
            List<String> orgAllNames = orgs.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrgNames(orgAllNames);
        }
    }
}




