package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserLimit;
import com.geoway.design.biz.mapper.SysUserLimitMapper;
import com.geoway.design.biz.service.sys.SysUserLimitService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_limit】的数据库操作Service实现
* @createDate 2024-09-21 15:20:08
*/
@Service
public class SysUserLimitServiceImpl extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
    implements SysUserLimitService {

    private final int const_blacklist = 1;
    private final int const_whitelist = 2;

    @Override
    public void saveOneLimit(SysUserLimit userLimit) {
        boolean isNew = true;
        if(StrUtil.isNotBlank(userLimit.getId())){
            isNew = this.getById(userLimit.getId()) == null;
        }

        if(isNew){
            LambdaQueryWrapper<SysUserLimit> queryWrapper =  Wrappers.lambdaQuery();
            queryWrapper.eq(SysUserLimit::getUserid,userLimit.getUserid());
            queryWrapper.eq(SysUserLimit::getAppid,userLimit.getAppid());
            queryWrapper.last(" limit 1");

            SysUserLimit existLimit = this.getOne(queryWrapper);
            if(existLimit != null){
                userLimit.setId(existLimit.getId());
            }else{
                userLimit.setCreatetime(new Date());
            }
        }
        this.saveOrUpdate(userLimit);
    }

    @Override
    public void bactchSaveWithJSON(String jsonArrayStr) {
        List<SysUserLimit> userLimits = JSONArray.parseArray(jsonArrayStr,SysUserLimit.class);
        if(userLimits != null){
            for (SysUserLimit userLimit: userLimits){
                this.saveOneLimit(userLimit);
            }
        }
    }

    @Override
    public boolean isValid(String appId,String userId) {
        boolean isValid = true;
        LambdaQueryWrapper<SysUserLimit> queryWrapper =  Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserLimit::getUserid,userId);

        List<SysUserLimit> userLimits = this.list(queryWrapper);
        for(SysUserLimit userLimit: userLimits){
            boolean appIdValid = userLimit.getAppid().equals("-1") || userLimit.getAppid().equals(appId);
            boolean timeValid = userLimit.getExpiretime() == null || userLimit.getExpiretime().getTime() > System.currentTimeMillis();
            if(userLimit.getLimittype() == const_blacklist && appIdValid && timeValid){
                isValid = false;
                break;
            }
        }

        return isValid;
    }

    @Override
    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam,String username,String tel, int page, int size) throws Exception {

        MPJQueryMapperUtil<SysUserLimit> qmu = new MPJQueryMapperUtil<>();
        MPJLambdaWrapper<SysUserLimit> queryWrapper = qmu.queryMapper(filterParam, sortParam, SysUserLimit.class);

        queryWrapper.selectAll(SysUserLimit.class);
        queryWrapper.selectAs("su",SysUser::getName,SysUserLimit::getUsername);
        queryWrapper.selectAs("su",SysUser::getTel,SysUserLimit::getTel);
        queryWrapper.selectAs("su",SysUser::getEmail,SysUserLimit::getEmail);
        queryWrapper.leftJoin(SysUser.class,"su",SysUser::getId,SysUserLimit::getUserid);
        if(StrUtil.isNotBlank(username)){
            queryWrapper.like(SysUser::getName,username);
        }
        if(StrUtil.isNotBlank(tel)){
            queryWrapper.like(SysUser::getTel,tel);
        }

        Page<SysUserLimit> pageT = new Page<>(page, size);
        IPage<SysUserLimit> pageResults = this.selectJoinListPage(pageT,SysUserLimit.class,queryWrapper);

        return pageResults;
    }
}




