package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.SysUserRoleMapper;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.vo.SysRoleVO;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_user_role】的数据库操作Service实现
* @createDate 2021-11-30 19:24:11
*/
@Service
public class SysUserRoleServiceImpl extends ServiceImpl<SysUserRoleMapper, SysUserRole>
    implements ISysUserRoleService {

    @Override
    @OpLog(name = "修改用户所属角色", opType = OpLog.OpType.update)
    public void updateUserRole(String userId, List<String> roleIds) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getUserid,userId);

        //先移除
        this.remove(wrapper);
        if(roleIds == null){
            return;
        }
        List<SysUserRole> userRoles = new ArrayList<>();
        for(String roleId: roleIds){
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);

            userRoles.add(userRole);
        }
        if(userRoles.size() > 0){
            this.saveBatch(userRoles);
        }

    }

    @Override
    public void updateRoleUsers(String roleId, List<String> userIds) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid,roleId);

        //先移除
        this.remove(wrapper);
        List<SysUserRole> userRoles = new ArrayList<>();
        for(String userId: userIds){
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);

            userRoles.add(userRole);
        }
        if(userRoles.size() > 0){
            this.saveBatch(userRoles);
        }
    }

    @Override
    public Map<String, String> queryRoleByIds(List<String> ids) {
        List<SysRoleVO> sysRoleVOS = this.baseMapper.queryRole(ids);
        return sysRoleVOS.stream().collect(Collectors.toMap(SysRoleVO::getId, SysRoleVO::getName));
    }
}




