package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.enums.UserStatus;
import com.geoway.design.base.enums.register.EnumUserType;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.dto.UserRegistDTO;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.SysOplogMapper;
import com.geoway.design.biz.mapper.SysRoleMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.design.biz.service.sys.*;
import com.geoway.design.biz.vo.SysOrganizationVO;
import com.geoway.design.biz.vo.SysRoleVO;
import com.geoway.design.biz.vo.SysUserVO;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.constant.AppConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author daidongdong
 * @description 针对表【sys_user】的数据库操作Service实现
 * @createDate 2021-12-21 11:53:24
 */
@Service
@Transactional
public class SysUserServiceImpl extends ServiceImpl<SysUserMapper, SysUser> implements ISysUserService {

    @Autowired
    private SysUserMapper sysUserMapper;
    private static final String REGIST_DEFAULT_ORG_NAME = "无组织机构用户";
    private static final String REGIST_DEFAULT_ROLE_PARENT = "注册用户默认角色";
    private static final String REGIST_DEFAULT_ROLE_NAME = "注册用户";
    @Autowired
    private IUserService userService;
    @Autowired
    ISysUserRoleService sysUserRoleService;

    @Autowired
    IUserOrganizationService sysUserOrganizationService;

    @Autowired
    ISysUserRegionService sysUserRegionService;

    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private IOrganizationService sysOrganizationService;

    @Autowired
    ISysRegionService sysRegionService;

    @Autowired
    IFunctionSysService.ISysUserSecurityService sysUserSecurityService;

    @Autowired
    private INsMenuService iNsMenuService;

    @Autowired
    IApplicationSysService.ISysImageService sysImageService;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private SysOplogMapper sysOplogMapper;

    @Autowired
    SysRoleMapper sysRoleMapper;

    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;

    @Autowired
    private ICaptchaService commonService;

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) throws Exception {
        userService.saveOrUp(user, file, deletePhoto);
    }

    @Override
    public void batchSave(List<SysUser> users) throws Exception {
        userService.batchSave(users);
    }

    @Override
    public List<SysUser> queryList(String filterParam) throws Exception {
        return userService.queryList(filterParam);
    }

    @Override
    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        return userService.queryList(filterParam, withRoleOrg);
    }

    @Override
    public SysUser queryOne(String id) {
        return userService.query(id);
    }

    @Override
    public List<SysUser> queryByIds(List<String> ids) {
        return userService.query(ids);
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size) throws Exception {
        return userService.queryPage(filterParam, page, size);
    }

    @Override
    public void deleteOne(String id) throws Exception {
        userService.delete(id);
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        userService.batchDelete(ids);
    }

    @Override
    public List<SysRole> queryRelRoles(String userId) {
        List<SysRole> roles = sysRoleService.queryUserRoles(userId);
        return roles;
    }

    @Override
    public List<SysOrganization> queryRelOrgs(String userId) {
        List<SysOrganization> orgs = sysOrganizationService.queryUserOrgs(userId);
        return orgs;
    }

    @Override
    public List<SysRegion> queryRelRegions(String userId) {
        List<SysRegion> regions = sysRegionService.queryUserRegions(userId);
        return regions;
    }

    @Override
    public void changeUserPassword(String userId, String password) {
        userService.changePassword(userId, password);
    }

    @Override
    public Boolean modifyPassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        String verifyStr = commonService.queryCaptcha(verifyCodeUid);
        if (StrUtil.isBlank(verifyStr)) {
            throw new ServiceException("无效的验证码");
        }
        JSONObject jsonObject = JSON.parseObject(verifyStr);
        if (!verifyCode.equals(jsonObject.getString("verifyCode"))) {
            throw new ServiceException("无效的验证码");
        }
        List<SysUser> users = this.queryList("telEncrypt_EQ_" + AESUtils.encrypt(phoneNum, AESUtils.KEY));
        if (users == null || users.size() == 0) {
            throw new ServiceException("此手机号码未注册");
        }
        userService.changePassword(users.get(0).getId(), password);
        return true;
    }

    @Override
    public SysUserVO getUserInfoByUserId(String userId) {
        SysUser sysUser = userService.query(userId);
        if (ObjectUtil.isNull(sysUser)) {
            throw new RuntimeException("用户信息不存在！");
        }
        SysUserVO sysUserVO = new SysUserVO();
        sysUserVO.setAccount(sysUser.getAccout());
        sysUserVO.setAddress(sysUser.getAddress());
        sysUserVO.setAlisName(sysUser.getAname());
        sysUserVO.setBh(sysUser.getBh());
        sysUserVO.setId(sysUser.getId());
        sysUserVO.setName(sysUser.getName());
        sysUserVO.setTel(sysUser.getTel());
        //构造角色信息
        List<SysRoleVO> roleVOS = sysRoleMapper.getSysRoleVO(userId);
        sysUserVO.setRoleVOList(roleVOS);
        //组织信息
        List<SysOrganization> orgs = sysOrganizationService.queryUserOrgs(userId);
        List<SysOrganizationVO> orgVOS = new ArrayList<>();
        for (SysOrganization org : orgs) {
            SysOrganizationVO orgVO = new SysOrganizationVO();
            orgVO.setId(org.getId());
            orgVO.setName(org.getName());
            orgVO.setDesc(org.getDesc());
            orgVOS.add(orgVO);
        }

        sysUserVO.setOrganizationVOList(orgVOS);
        // 构造行政区信息
        List<SysUserRegion> sysUserRegionList = sysUserRegionService.list(new LambdaQueryWrapper<SysUserRegion>()
                .eq(SysUserRegion::getUserid, userId).orderByAsc(SysUserRegion::getRegioncode));
        if (ObjectUtil.isNotEmpty(sysUserRegionList)) {
            sysUserVO.setRegionCode(sysUserRegionList.get(0).getRegioncode());
        }
        if (ObjectUtil.isNotEmpty(sysUserVO.getRoleVOList())) {
            sysUserVO.setMenuTreeList(iNsMenuService.getSysMenuVoTree(
                    sysUserVO.getRoleVOList().
                            stream().map(SysRoleVO::getId).
                            collect(Collectors.toList())));
        }
        return sysUserVO;
    }

    @Override
    public Boolean userRegistrer(UserRegistDTO userDTO) throws Exception {
        SysUser sysUser = userDto2SysUser(userDTO);
        isUserRepeat(sysUser); //用户查重
        if (StrUtil.isBlank(sysUser.getId())) {
            this.sysUserMapper.insert(sysUser);
        } else {
            this.sysUserMapper.updateById(sysUser); //保存用户
        }
        saveRegisterUserOrg(userDTO, sysUser);  //保存机构
        if (StrUtil.isNotEmpty(userDTO.getRegionCodes())) {
            //保存辖区
            sysUserRegionService.updateUserRegions(sysUser.getId(), Arrays.asList(userDTO.getRegionCodes().split((","))));
        }
        saveRegisterUserRole(sysUser); //保存
        this.changeUserPassword(sysUser.getId(), "e10adc3949ba59abbe56e057f20f883e");
        return true;
    }


    /**
     * 检验用户账户是否重读
     *
     * @param user 用户实体
     * @return
     * @throws Exception
     */
    private boolean isUserRepeat(SysUser user) throws Exception {
        //判断名称和账号是否重复
        LambdaQueryWrapper<SysUser> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUser::getAccout, user.getAccout());
        //新增: 检查账号是否重复，更新时不用
        int iCount = this.sysUserMapper.selectCount(wrapper);
        if (iCount > 0) {
            throw new Exception("账户:" + user.getAccout() + "  已存在！");
        }
        return true;
    }

    /**
     * 注册用户字段与系统用户字段映射
     *
     * @param userDTO
     * @return
     */
    private SysUser userDto2SysUser(UserRegistDTO userDTO) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties(userDTO, sysUser);
        sysUser.setAccout(userDTO.getAccount());
        sysUser.setName(userDTO.getAname());
        sysUser.setSource("注册用户");
        sysUser.setType(ObjectUtil.isNotNull(userDTO.getType()) ? userDTO.getType() : EnumUserType.DEFAULT.value);
        sysUser.setStatus(StrUtil.isNotEmpty(userDTO.getOrgIds()) ? UserStatus.DISABLE.getCode() : UserStatus.OK.getCode());
        return sysUser;
    }

    /**
     * 保存注册用户机构信息
     *
     * @param userDTO 注册用户信息
     * @param sysUser 系统用户实体
     * @return
     * @throws Exception
     */
    private boolean saveRegisterUserOrg(UserRegistDTO userDTO, SysUser sysUser) throws Exception {
        //若有机构则直接挂接
        if (StrUtil.isNotEmpty(userDTO.getOrgIds())) {
            sysUserOrganizationService.updateUserOrg(sysUser.getId(), Arrays.asList(userDTO.getOrgIds().split(",")));
        } else {
            //先查有没有默认机构，没有则先新增
            SysOrganization defaultOrg = sysOrganizationService.findOneByName(REGIST_DEFAULT_ORG_NAME, "");
            if (ObjectUtil.isNull(defaultOrg)) {
                defaultOrg = new SysOrganization();
                defaultOrg.setName(REGIST_DEFAULT_ORG_NAME);
                defaultOrg.setAllname(REGIST_DEFAULT_ORG_NAME);
                defaultOrg.setDesc("注册时没选择机构的用户会在这下面显示");
                defaultOrg.setLevel(1);
                defaultOrg.setPid("0");
                defaultOrg.setOrder(999);
                sysOrganizationService.saveOrUp(defaultOrg);
            }
            sysUserOrganizationService.updateUserOrg(sysUser.getId(), Arrays.asList(defaultOrg.getId()));
        }
        return true;
    }

    /**
     * 保存注册用户角色
     *
     * @param sysUser
     * @return
     * @throws Exception
     */
    private boolean saveRegisterUserRole(SysUser sysUser) throws Exception {
        //先查有没有默认机构，没有则先新增
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName, "注册用户");
        SysRole defaultRole = sysRoleService.getOne(wrapper);
        if (ObjectUtil.isNull(defaultRole)) {
            //先创建角色分类目录
            SysRole parenDefault = new SysRole();
            parenDefault.setName(REGIST_DEFAULT_ROLE_PARENT);
            parenDefault.setAllname(REGIST_DEFAULT_ROLE_PARENT);
            parenDefault.setLevel(1);
            parenDefault.setType(0);
            parenDefault.setBz("注册用户默认角色，初次用户注册时系统会自动创建");
            sysRoleService.saveOrUp(parenDefault);

            //再创建角色
            defaultRole = new SysRole();
            defaultRole.setName(REGIST_DEFAULT_ROLE_NAME);
            defaultRole.setAllname(parenDefault.getName() + "/" + REGIST_DEFAULT_ROLE_NAME);
            defaultRole.setLevel(2);
            defaultRole.setType(1);
            defaultRole.setPid(parenDefault.getId());
            defaultRole.setParents(parenDefault.getId());
            defaultRole.setBz("注册用户会默认挂接到此角色下面，系统会自动创建");
            sysRoleService.saveOrUp(defaultRole);
        }
        sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(defaultRole.getId()));
        return true;
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) throws Exception {
        userService.exportUsers(filterParam, isTemplate, response);
    }

    /**
     * 用户Excel批量导入
     *
     * @param userList        用户列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     * @throws Exception
     */
    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        return userService.importUsers(userList, isUpdateSupport);
    }

    @Override
    public void updateRoles(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank(otherParams)) {
            try {
                UserRelParams userParams = JSON.parseObject(otherParams, UserRelParams.class);
                sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
            } catch (Exception ex) {
                throw new ServiceException("错误:" + ex.getMessage());
            }
        }
    }

    @Override
    public Map<String, Object> queryCount(String filterParam) throws Exception {
        Map<String, Object> result = new HashMap<String, Object>();
        int all = 0;
        int online = 0;
        int offline = 0;
        //获取所有用户
        all = userService.queryCount(filterParam);
        //获取在线用户
        List<String> list = redisTemplate.opsForList().range("UserMonitor", 0, -1);
        if (list != null && list.size() > 0) {
            List<String> clearTokens = new ArrayList<String>();
            List<String> userIds = new ArrayList<String>();
            List<SsoUser> users = new ArrayList<SsoUser>();
            list.forEach(accessToken -> {
                Object atcStr = redisTemplate.opsForValue().get(AppConstant.REDIS_TOKEN_PREFIX + accessToken);
                if (atcStr != null && StringUtils.isNotEmpty(atcStr.toString())) {
                    AccessTokenContent user = JSONObject.parseObject(atcStr.toString(), AccessTokenContent.class);
                    SsoUser ssoUser = user.getUser();
                    if (ssoUser != null) {
                        String userId = ssoUser.getUserid();
                        if (!userIds.contains(userId)) {
                            userIds.add(userId);
                            users.add(ssoUser);
                        }
                    }
                } else {
                    clearTokens.add(accessToken);
                }
            });

            //清空已超时用户
            if (clearTokens.size() > 0) {
                clearTokens.forEach(accessToken -> {
                    redisTemplate.opsForList().remove("UserMonitor", 0, accessToken);
                });
            }

            if (users.size() > 0) {
                List<SysOplog> logs = sysOplogMapper.queryOnlineUserMsg(userIds);
                users.forEach(user -> {
                    String userId = user.getUserid();
                    for (int i = 0; i < logs.size(); i++) {
                        SysOplog temp = logs.get(i);
                        if (temp.getUserid().equals(userId)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            user.setIp(temp.getIp());
                            user.setLoginTime(sdf.format(temp.getCreatetime()));
                            break;
                        }
                    }
                });
            }

            online = users.size();
            offline = all - online;
            result.put("users", users);
        }

        result.put("all", all);
        result.put("online", online);
        result.put("offline", offline);

        return result;
    }

    @Override
    public void changePasswordByUserId(String userId, String oldPwd, String newPwd) throws Exception {
        userService.changePassword(userId, oldPwd, newPwd);
    }


    @Override
    public List<SysUser> queryRolerUsers(String roleId) {

        return null;
    }

    @Override
    public List<SysUser> queryOrgUsers(String roleId) {
        return null;
    }

    @Override
    public List<SysUser> queryAllNonOrgUsers() {
        return null;
    }

    @Override
    public void encryptPhone(String phone) {
        String filterParam = "";
        if (StrUtil.isNotBlank(phone)) {
            filterParam = "tel_EQ_" + phone;
        }
        int count = userService.queryCount(filterParam);
        int pages = count / 100 + 1;
        for (int i = 1; i <= pages; i++) {
            IPage<SysUser> records = userService.queryPage(filterParam, i, 100);
            for (SysUser user : records.getRecords()) {
                if (!user.getTel().contains("****")) {
                    try {
                        user.setTelEncrypt(AESUtils.encrypt(user.getTel(), AESUtils.KEY));
                        user.setTel(user.getTel().substring(0, 3) + "****" + user.getTel().substring(7, 11));
                        sysUserMapper.updateById(user);
                    } catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void decryptPhone(String encryptPhone) {
        String filterParam = "";
        if (StrUtil.isNotBlank(encryptPhone)) {
            filterParam = "telEncrypt_EQ_" + encryptPhone;
        }
        int count = userService.queryCount(filterParam);
        int pages = count / 100 + 1;
        for (int i = 1; i <= pages; i++) {
            IPage<SysUser> records = userService.queryPage(filterParam, i, 100);
            for (SysUser user : records.getRecords()) {
                if (user.getTelEncrypt()!=null) {
                    try {
                        String tel = AESUtils.decrypt(user.getTelEncrypt(), AESUtils.KEY);
                        user.setTelEncrypt(null);
                        user.setTel(tel);
                        sysUserMapper.updateById(user);
                    } catch (Exception ex) {

                    }
                }
            }
        }
    }

    @Override
    public SysUser queryOneByTel(String tel) {

        LambdaQueryWrapper<SysUser>  queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getTel,tel);
        queryWrapper.last(" limit 1");

        return this.getOne(queryWrapper);
    }
}




