package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysXzqRegion;
import com.geoway.design.biz.mapper.SysXzqRegionMapper;
import com.geoway.design.biz.service.sys.ISysXzqRegionService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author daidongdong
* @description 针对表【sys_xzq_region】的数据库操作Service实现
* @createDate 2022-01-24 16:52:28
*/
@Service
public class SysXzqRegionServiceImpl extends ServiceImpl<SysXzqRegionMapper, SysXzqRegion>
    implements ISysXzqRegionService {

    @Override
    public List<SysXzqRegion> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils<SysXzqRegion> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam,SysXzqRegion.class);
        queryWrapper.orderByAsc("code");
        List<SysXzqRegion>  regions = this.list(queryWrapper);

        return  regions;
    }

    @Override
    public List<SysXzqRegion> queryRegionTree(String filterParam) throws Exception {
        List<SysXzqRegion>  regions = this.queryList(filterParam);
        return constructTree(regions);
    }

    private List<SysXzqRegion> constructTree(List<SysXzqRegion>  list){

        int minLevel = 9;
        Map<String, List<SysXzqRegion>> mapParam = new HashMap<>();
        for (SysXzqRegion region : list) {
            String key = region.getPcode();
            if (!StringUtils.isEmpty(key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(region);
                } else {
                    List<SysXzqRegion> childList = new ArrayList<>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }

            if (region.getLevel() < minLevel) {
                minLevel = region.getLevel();
            }
        }
        if(minLevel < 1){
            minLevel = 1;
        }
        List<SysXzqRegion> results = new ArrayList<>();
        for (SysXzqRegion region : list) {
            String key = region.getCode();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                region.setChildren(mapParam.get(key));
            }
            if (region.getLevel() == minLevel) {
                results.add(region);
            }
        }

        return results;
    }
}




