package com.geoway.design.biz.service.uis.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.design.biz.dto.uis.SimpleUserDTO;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.biz.service.uis.IUISService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.Oauth2Utils;
import org.junit.platform.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName UISServiceImpl
 * @Description TODO
 * @date 2024/3/12 15:44
 * @Version 1.0
 */
@Service
public class UISServiceImpl implements IUISService {
    @Value("${sso.server.url}")
    private String serverUrl;

    @Autowired
    private ISysUserService sysUserService;

    @Autowired
    private IOrganizationService sysOrganizationService;

    @Autowired
    private ISysRoleService sysRoleService;

    @Autowired
    private ISysPermissionService sysPermissionService;
    @Override
    public List<SimpleUserDTO> getUserInfo(Map<String, String> map) {
        List<SimpleUserDTO> arrayList = new ArrayList<>();
        SysUser sysUser = null;
        String token = map.get("token");
        String userId = map.get("userId");
        //token是必传
        if (StringUtils.isBlank(token)) {
            throw new RuntimeException("无效token或token已过期");

        }
        //只传token过来的时候从session中取用户userId
        if (StringUtils.isBlank(userId)) {
            Result<RpcAccessToken> userResult = Oauth2Utils.queryAccessToken(serverUrl, token);
            if (userResult != null && userResult.isSuccess() && userResult.getData() != null) {
                userId = userResult.getData().getUser().getId();
            } else {
                throw new RuntimeException("查询用户失败:" + userResult.getMessage());

            }
        }
        sysUser=sysUserService.queryOne(userId);
        // ExternalParamDTO dto = new ExternalParamDTO();
        // dto.setUsername(map.get("username"));
        // dto.setTelPhone(map.get("telPhone"));
        //dto.setUserId(userId);
        //sysUser = externalBaseService.queryUserInfo(dto);
        if (ObjectUtil.isNull(sysUser)) {
            throw new RuntimeException("此用户不存在,或当前登录token与用户信息不一致");
        }
        List<SysRole> roles = sysUserService.queryRelRoles(userId);
        List<SysOrganization> orgs = sysUserService.queryRelOrgs(userId);
        List<SysRegion> regions = sysUserService.queryRelRegions(userId);

        SimpleUserDTO simpleUser = new SimpleUserDTO().sysUser2simpleUser(sysUser, orgs, roles, regions);
        arrayList.add(simpleUser);
        return arrayList;
    }

    @Override
    public void modifyUserInfo(Map<String, String> map) {
        String userId = map.get("id");
        String userPwd = map.get("password");
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(userPwd)) {
            throw new RuntimeException("用户id和密码参数不能为空");
        }
        if (sysUserService.queryOne(userId) == null) {
            throw new RuntimeException("此用户不存在!");
        }
        sysUserService.changeUserPassword(userId, userPwd);
    }

    @Override
    public List<SimpleUserDTO> getUserList(String filterParam) {
        try {
            List<SysUser> userList = sysUserService.queryList(filterParam,false);
            List<SimpleUserDTO> simpleUserList = new ArrayList<>();
            for (SysUser sysUser : userList) {
                SimpleUserDTO simpleUserDTO = new SimpleUserDTO().sysUser2simpleUser(sysUser);
                simpleUserList.add(simpleUserDTO);
            }
            return simpleUserList;
        }catch (Exception exceptions){
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public List<SysOrganization> getOrgTree(Map<String, String> paramMap) {
        String pid = paramMap.get("pid");
        String myFilterParam = "";
        if (StringUtils.isNotBlank(pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> organizationList = sysOrganizationService.queryTree(myFilterParam);
            return organizationList;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysOrganization> getOrgInfo(Map<String, String> paramMap) {
        String pid = paramMap.get("pid");
        String myFilterParam = "";
        if (StringUtils.isNotBlank(pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> orgList = sysOrganizationService.queryList(myFilterParam);
           return orgList;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleTree(String filterParam) {
        try {
            List<SysRole> roleTree = sysRoleService.queryTree(filterParam);
            return roleTree;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysPermission> queryRolePermissions(Map<String, String> paramMap) {
        try {
            List<SysPermission>  permissions = sysPermissionService.queryRolePermissons(paramMap.get("roleIds"));
            return  permissions;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleList(String filterParam) {
        try {
            if(StrUtil.isEmpty(filterParam)){
                filterParam = "";
            }
            filterParam += ";type_EQ_1";
            List<SysRole> roles = sysRoleService.queryList(filterParam);
            return roles;
        } catch (Exception e) {
            throw new RuntimeException(e);

        }
    }

    @Override
    public List<SysUser> queryRoleUsers(String roleId) {
        try {
            List<SysUser> users = sysRoleService.queryRelUsers(roleId);
            return users;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
