package com.geoway.design.biz.util;

import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.encryption.Md5Utils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author 连世忠
 * @ClassName PasswordUtil
 * @Description 密码帮助类
 * @date 2024/4/3 9:42
 * @Version 1.0
 */
@Service
public class PasswordUtil {
    @Value("${password.encryptMethod:MD5}")
    private String EncryptMethod;

    /**
     * 获取md5密码
     * @param password
     * @return
     */
    public String getMD5Password(String password){
        try {
            if (EncryptMethod.toUpperCase().equals("MD5")) {
                return password;
            }else if(EncryptMethod.toUpperCase().equals("AES")) {
                String realPassword= AESUtils.decrypt(password, AESUtils.KEY);
                return Md5Utils.getMD5Str(realPassword,"UTF-8");
            }else if(EncryptMethod.toUpperCase().equals("REAL")) {
                return Md5Utils.getMD5Str(password,"UTF-8");
            }else {
                throw new RuntimeException("不支持的密码加密方式");
            }

        }catch (Exception exception){
            throw new RuntimeException(exception);
        }
    }

    /**
     * 获取AES密码
     * @param password
     * @return
     */
    public String getAESPassword(String password){
        try {
            if (EncryptMethod.toUpperCase().equals("MD5")) {
                throw new RuntimeException("md5的加密方式无法解密");
            } else if (EncryptMethod.toUpperCase().equals("AES")) {
                return password;
            } else if (EncryptMethod.toUpperCase().equals("REAL")) {
                return AESUtils.encrypt(password, AESUtils.KEY);
            } else {
                throw new RuntimeException("不支持的密码加密方式");
            }
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }
    }
    /**
     * 获取明文密码
     * @param password
     * @return
     */
    public String getRealPassword(String password){
        return getRealPassword(password,EncryptMethod);
    }
    /**
     * 获取明文密码
     * @param password
     * @return
     */
    public String getRealPassword(String password,String srcEncryptMethod){
        try {
            if (srcEncryptMethod.toUpperCase().equals("MD5")) {
                throw new RuntimeException("md5的加密方式无法解密");
            } else if (srcEncryptMethod.toUpperCase().equals("AES")) {
                return AESUtils.decrypt(password, AESUtils.KEY);
            } else if (srcEncryptMethod.toUpperCase().equals("REAL")) {
                return password;
            } else {
                throw new RuntimeException("不支持的密码加密方式");
            }
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }
    }
    /**
     * 将密码转换成当前系统的加密模式
     * @param srcPassword
     * @param srcEncryptMethod
     * @return
     */
    public String getTargetPassword(String srcPassword,String srcEncryptMethod){
        try {
            if(srcEncryptMethod.toUpperCase().equals(EncryptMethod.toUpperCase())){
                return srcPassword;
            }
            String realPassword=getRealPassword(srcPassword,srcEncryptMethod);
            if (EncryptMethod.toUpperCase().equals("MD5")) {
                return Md5Utils.getMD5Str(realPassword, "UTF-8");
            } else if (EncryptMethod.toUpperCase().equals("AES")) {
                return AESUtils.encrypt(realPassword, AESUtils.KEY);
            } else if (EncryptMethod.toUpperCase().equals("REAL")) {
                return realPassword;
            } else {
                throw new RuntimeException("不支持的密码加密方式");
            }
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }

    }
}
