/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.dto.uis;

import com.geoway.design.biz.dto.uis.ApplicationInfo;
import com.geoway.design.biz.dto.uis.OrganizationDTO;
import com.geoway.design.biz.dto.uis.RegionDTO;
import com.geoway.design.biz.dto.uis.SimpleRoleDTO;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.entity.SysUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleUserDTO {
    private static final long serialVersionUID = 1L;
    private String id;
    private String username;
    private String name;
    private String password;
    private Integer sex;
    private String email;
    private String telphone;
    private String phone;
    private String phonework;
    private String rname;
    private Integer state;
    private String registerAppId;
    private Date registertime;
    private String orgIds;
    private String regioncode;
    private List<ApplicationInfo> applications;
    private List<OrganizationDTO> organizations;
    private List<RegionDTO> regions;
    private List<SimpleRoleDTO> roles;
    private String imgId;

    public SimpleUserDTO sysUser2simpleUser(SysUser user) {
        this.setId(user.getId());
        this.setName(user.getAccout());
        this.setUsername(user.getAccout());
        this.setRname(user.getAname());
        this.setTelphone(user.getTel());
        this.setPhone(user.getTel());
        this.setPhonework(user.getWorktel());
        this.setEmail(user.getEmail());
        this.setSex(user.getSex());
        this.setRegistertime(user.getCreatetime());
        this.setState((int)user.getStatus());
        return this;
    }

    public SimpleUserDTO sysUser2simpleUser(SysUser user, List<SysOrganization> orgList, List<SysRole> roleList, List<SysRegion> regionList) {
        this.setId(user.getId());
        this.setName(user.getAccout());
        this.setUsername(user.getAccout());
        this.setRname(user.getAname());
        this.setTelphone(user.getTel());
        this.setPhone(user.getTel());
        this.setPhonework(user.getWorktel());
        this.setEmail(user.getEmail());
        this.setSex(user.getSex());
        this.setRegistertime(user.getCreatetime());
        this.setState((int)user.getStatus());
        this.setImgId(user.getImgid());
        this.setOrgIds(this.org2Orgids(orgList));
        this.setOrganizations(this.org2UisOrg(orgList));
        this.setRegioncode(this.regionList2Code(regionList));
        this.setRoles(this.role2UisRole(roleList));
        this.setRegions(this.region2UisRegion(regionList));
        return this;
    }

    public List<OrganizationDTO> org2UisOrg(List<SysOrganization> orgs) {
        ArrayList<OrganizationDTO> organizationDTOS = new ArrayList<OrganizationDTO>();
        for (SysOrganization org : orgs) {
            OrganizationDTO uisOrgItem = new OrganizationDTO();
            uisOrgItem.setId(org.getId());
            uisOrgItem.setName(org.getName());
            uisOrgItem.setText(org.getAname());
            uisOrgItem.setCode(org.getCode());
            uisOrgItem.setLevel(org.getLevel());
            uisOrgItem.setPid(org.getPid());
            uisOrgItem.setDescription(org.getDesc());
            organizationDTOS.add(uisOrgItem);
        }
        for (int index = 0; index < orgs.size(); ++index) {
            SysOrganization org = orgs.get(index);
            OrganizationDTO organizationDTO = (OrganizationDTO)organizationDTOS.get(index);
            List<SysOrganization> children = org.getChildren();
            if (children == null || children.size() <= 0) continue;
            organizationDTO.setChildren(this.org2UisOrg(org.getChildren()));
        }
        return organizationDTOS;
    }

    private String org2RegionCode(List<SysOrganization> orgs) {
        String regionCode = "";
        if (orgs != null && orgs.size() > 0) {
            regionCode = orgs.get(0).getCode();
        }
        return regionCode;
    }

    public List<SimpleRoleDTO> role2UisRole(List<SysRole> roles) {
        ArrayList<SimpleRoleDTO> roleDTOS = new ArrayList<SimpleRoleDTO>();
        for (SysRole sysRole : roles) {
            SimpleRoleDTO uisRoleItem = new SimpleRoleDTO();
            uisRoleItem.setId(sysRole.getId());
            uisRoleItem.setRolename(sysRole.getName());
            uisRoleItem.setLevel(sysRole.getLevel());
            uisRoleItem.setCreateTime(sysRole.getCreateTime());
            roleDTOS.add(uisRoleItem);
        }
        return roleDTOS;
    }

    public List<RegionDTO> region2UisRegion(List<SysRegion> regions) {
        SysRegion sysRegion;
        ArrayList<RegionDTO> regionDTOS = new ArrayList<RegionDTO>();
        Iterator<SysRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            RegionDTO uisRegionItem = new RegionDTO();
            sysRegion = iterator.next();
            uisRegionItem.setId(sysRegion.getId());
            uisRegionItem.setCode(sysRegion.getCode());
            uisRegionItem.setName(sysRegion.getName());
            uisRegionItem.setLevel(sysRegion.getLevel());
            uisRegionItem.set_parentId(sysRegion.getPcode());
            uisRegionItem.setPid(sysRegion.getPcode());
            regionDTOS.add(uisRegionItem);
        }
        for (int index = 0; index < regions.size(); ++index) {
            sysRegion = regions.get(index);
            RegionDTO regionDTO = (RegionDTO)regionDTOS.get(index);
            List<SysRegion> children = sysRegion.getChildren();
            if (children == null || children.size() <= 0) continue;
            regionDTO.setChildren(this.region2UisRegion(sysRegion.getChildren()));
        }
        return regionDTOS;
    }

    private String org2Orgids(List<SysOrganization> orgs) {
        return orgs.stream().filter(org -> !org.getId().isEmpty()).map(org -> org.getId()).collect(Collectors.joining(","));
    }

    private String regionList2Code(List<SysRegion> regions) {
        String regionCode = "";
        int level = 1;
        for (SysRegion sysRegion : regions) {
            if (sysRegion.getLevel() >= level) {
                regionCode = sysRegion.getCode();
            }
            level = sysRegion.getLevel();
        }
        return regionCode;
    }

    private List<SysRegion> filterRegionList(List<SysRegion> regions) {
        ArrayList<SysRegion> filterRegions = new ArrayList<SysRegion>();
        int level = 1;
        Iterator<SysRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            filterRegions = new ArrayList();
            SysRegion sysRegion = iterator.next();
            if (sysRegion.getLevel() >= level) {
                filterRegions.add(sysRegion);
            }
            level = sysRegion.getLevel();
        }
        return filterRegions;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getSex() {
        return this.sex;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelphone() {
        return this.telphone;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPhonework() {
        return this.phonework;
    }

    public String getRname() {
        return this.rname;
    }

    public Integer getState() {
        return this.state;
    }

    public String getRegisterAppId() {
        return this.registerAppId;
    }

    public Date getRegistertime() {
        return this.registertime;
    }

    public String getOrgIds() {
        return this.orgIds;
    }

    public String getRegioncode() {
        return this.regioncode;
    }

    public List<ApplicationInfo> getApplications() {
        return this.applications;
    }

    public List<OrganizationDTO> getOrganizations() {
        return this.organizations;
    }

    public List<RegionDTO> getRegions() {
        return this.regions;
    }

    public List<SimpleRoleDTO> getRoles() {
        return this.roles;
    }

    public String getImgId() {
        return this.imgId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTelphone(String telphone) {
        this.telphone = telphone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setPhonework(String phonework) {
        this.phonework = phonework;
    }

    public void setRname(String rname) {
        this.rname = rname;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setRegisterAppId(String registerAppId) {
        this.registerAppId = registerAppId;
    }

    public void setRegistertime(Date registertime) {
        this.registertime = registertime;
    }

    public void setOrgIds(String orgIds) {
        this.orgIds = orgIds;
    }

    public void setRegioncode(String regioncode) {
        this.regioncode = regioncode;
    }

    public void setApplications(List<ApplicationInfo> applications) {
        this.applications = applications;
    }

    public void setOrganizations(List<OrganizationDTO> organizations) {
        this.organizations = organizations;
    }

    public void setRegions(List<RegionDTO> regions) {
        this.regions = regions;
    }

    public void setRoles(List<SimpleRoleDTO> roles) {
        this.roles = roles;
    }

    public void setImgId(String imgId) {
        this.imgId = imgId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleUserDTO)) {
            return false;
        }
        SimpleUserDTO other = (SimpleUserDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sex = this.getSex();
        Integer other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telphone = this.getTelphone();
        String other$telphone = other.getTelphone();
        if (this$telphone == null ? other$telphone != null : !this$telphone.equals(other$telphone)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$phonework = this.getPhonework();
        String other$phonework = other.getPhonework();
        if (this$phonework == null ? other$phonework != null : !this$phonework.equals(other$phonework)) {
            return false;
        }
        String this$rname = this.getRname();
        String other$rname = other.getRname();
        if (this$rname == null ? other$rname != null : !this$rname.equals(other$rname)) {
            return false;
        }
        String this$registerAppId = this.getRegisterAppId();
        String other$registerAppId = other.getRegisterAppId();
        if (this$registerAppId == null ? other$registerAppId != null : !this$registerAppId.equals(other$registerAppId)) {
            return false;
        }
        Date this$registertime = this.getRegistertime();
        Date other$registertime = other.getRegistertime();
        if (this$registertime == null ? other$registertime != null : !((Object)this$registertime).equals(other$registertime)) {
            return false;
        }
        String this$orgIds = this.getOrgIds();
        String other$orgIds = other.getOrgIds();
        if (this$orgIds == null ? other$orgIds != null : !this$orgIds.equals(other$orgIds)) {
            return false;
        }
        String this$regioncode = this.getRegioncode();
        String other$regioncode = other.getRegioncode();
        if (this$regioncode == null ? other$regioncode != null : !this$regioncode.equals(other$regioncode)) {
            return false;
        }
        List<ApplicationInfo> this$applications = this.getApplications();
        List<ApplicationInfo> other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !((Object)this$applications).equals(other$applications)) {
            return false;
        }
        List<OrganizationDTO> this$organizations = this.getOrganizations();
        List<OrganizationDTO> other$organizations = other.getOrganizations();
        if (this$organizations == null ? other$organizations != null : !((Object)this$organizations).equals(other$organizations)) {
            return false;
        }
        List<RegionDTO> this$regions = this.getRegions();
        List<RegionDTO> other$regions = other.getRegions();
        if (this$regions == null ? other$regions != null : !((Object)this$regions).equals(other$regions)) {
            return false;
        }
        List<SimpleRoleDTO> this$roles = this.getRoles();
        List<SimpleRoleDTO> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$imgId = this.getImgId();
        String other$imgId = other.getImgId();
        return !(this$imgId == null ? other$imgId != null : !this$imgId.equals(other$imgId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleUserDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telphone = this.getTelphone();
        result = result * 59 + ($telphone == null ? 43 : $telphone.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $phonework = this.getPhonework();
        result = result * 59 + ($phonework == null ? 43 : $phonework.hashCode());
        String $rname = this.getRname();
        result = result * 59 + ($rname == null ? 43 : $rname.hashCode());
        String $registerAppId = this.getRegisterAppId();
        result = result * 59 + ($registerAppId == null ? 43 : $registerAppId.hashCode());
        Date $registertime = this.getRegistertime();
        result = result * 59 + ($registertime == null ? 43 : ((Object)$registertime).hashCode());
        String $orgIds = this.getOrgIds();
        result = result * 59 + ($orgIds == null ? 43 : $orgIds.hashCode());
        String $regioncode = this.getRegioncode();
        result = result * 59 + ($regioncode == null ? 43 : $regioncode.hashCode());
        List<ApplicationInfo> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : ((Object)$applications).hashCode());
        List<OrganizationDTO> $organizations = this.getOrganizations();
        result = result * 59 + ($organizations == null ? 43 : ((Object)$organizations).hashCode());
        List<RegionDTO> $regions = this.getRegions();
        result = result * 59 + ($regions == null ? 43 : ((Object)$regions).hashCode());
        List<SimpleRoleDTO> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $imgId = this.getImgId();
        result = result * 59 + ($imgId == null ? 43 : $imgId.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleUserDTO(id=" + this.getId() + ", username=" + this.getUsername() + ", name=" + this.getName() + ", password=" + this.getPassword() + ", sex=" + this.getSex() + ", email=" + this.getEmail() + ", telphone=" + this.getTelphone() + ", phone=" + this.getPhone() + ", phonework=" + this.getPhonework() + ", rname=" + this.getRname() + ", state=" + this.getState() + ", registerAppId=" + this.getRegisterAppId() + ", registertime=" + this.getRegistertime() + ", orgIds=" + this.getOrgIds() + ", regioncode=" + this.getRegioncode() + ", applications=" + this.getApplications() + ", organizations=" + this.getOrganizations() + ", regions=" + this.getRegions() + ", roles=" + this.getRoles() + ", imgId=" + this.getImgId() + ")";
    }
}

