/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractUserServiceImpl
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserServiceImpl.class);
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private IUserOrganizationService sysUserOrganizationService;
    @Autowired
    private ISysUserRegionService sysUserRegionService;

    @Override
    public abstract SysUser query(String var1);

    @Override
    public abstract List<SysUser> query(List<String> var1);

    @Override
    public abstract List<SysUser> queryList(String var1);

    @Override
    public abstract IPage<SysUser> queryPage(String var1, int var2, int var3);

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u548c\u4fdd\u5b58\u7528\u6237");
    }

    @Override
    public void batchSave(List<SysUser> users) {
        for (SysUser user : users) {
            this.saveOrUp(user, null, false);
        }
    }

    @Override
    public void changePassword(String userId, String password) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u7528\u6237\u5bc6\u7801");
    }

    @Override
    public void delete(String id) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5220\u9664\u7528\u6237");
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7528\u6237\u5bfc\u51fa");
    }

    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7528\u6237\u6279\u91cf\u5bfc\u5165");
    }

    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u7528\u6237\u5bc6\u7801");
    }

    protected void saveUserRelInfo(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank((CharSequence)otherParams)) {
            try {
                UserRelParams userParams = (UserRelParams)JSON.parseObject((String)otherParams, UserRelParams.class);
                this.sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
                this.sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
                this.sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
            }
            catch (Exception ex) {
                throw new ServiceException("\u9519\u8bef:" + ex.getMessage());
            }
        }
    }
}

