/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.dev.impl.AbstractLoginServiceImpl;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class LocalLoginServiceImpl
extends AbstractLoginServiceImpl {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private PasswordUtil passwordUtil;

    @Override
    public Result<SsoUser> login(String username, String password, String tel, String uuid, String code, HttpServletRequest req) {
        this.validateCaptcha(uuid, code);
        return this.checkLogin(username, password, tel, null);
    }

    protected Result<SsoUser> checkLogin(String username, String password, String tel, List<String> sources) {
        SsoUser ssoUser = new SsoUser();
        try {
            int iCount;
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUser::getAccout, (Object)username);
            if (StrUtil.isNotBlank((CharSequence)tel)) {
                queryWrapper.eq(SysUser::getTelEncrypt, (Object)AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
            }
            if ((iCount = this.sysUserMapper.selectCount((Wrapper)queryWrapper).intValue()) == 0) {
                queryWrapper.clear();
                queryWrapper.and(gw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)gw.eq(SysUser::getName, (Object)username)).or()).eq(SysUser::getAccout, (Object)username);
                });
                if (StrUtil.isNotBlank((CharSequence)tel)) {
                    queryWrapper.eq(SysUser::getTel, (Object)tel);
                }
            }
            if (sources != null && sources.size() != 0) {
                queryWrapper.and(gw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)gw.in(SysUser::getSource, (Collection)sources);
                });
            }
            queryWrapper.last(" limit 1");
            SysUser user = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
            if (user == null || user.getId() == null) {
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            }
            if (!user.getStatus().toString().equals("1")) {
                return Result.createError((String)"\u7528\u6237\u5df2\u505c\u7528\u6216\u8005\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"f_id", (Object)user.getId())).eq((Object)"f_password", (Object)this.passwordUtil.getMD5Password(password)));
            if (sysUserSecurity == null) {
                return Result.createError((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef\u3002");
            }
            if (sysUserSecurity.getLock() != null && sysUserSecurity.getLock() == 1L) {
                return Result.createError((String)"\u7528\u6237\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!\u3002");
            }
            List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
            String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
            String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
            ssoUser.setId(user.getId());
            ssoUser.setUserid(user.getId());
            ssoUser.setUserName(user.getAname());
            ssoUser.setLoginName(user.getAccout());
            ssoUser.setRegionCode(regionCode);
            ssoUser.setRegionName(regionName);
            ssoUser.setCatalog(user.getCatalog());
            return Result.createSuccess((Object)ssoUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

