/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.support.spring.SpringUtils;
import com.geoway.design.biz.dto.CaptchaTextDTO;
import com.geoway.design.biz.service.dev.ILoginService;
import com.geoway.design.biz.service.dev.IUnityLoginService;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UnityLoginServiceImpl
implements IUnityLoginService {
    private static final Logger log = LoggerFactory.getLogger(UnityLoginServiceImpl.class);
    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private DefaultKaptcha defaultKaptcha;
    @Value(value="${sso.setting.login-type:1}")
    private String sysLoginTypes;

    @Override
    public CaptchaTextDTO createCaptchaText(HttpServletRequest req) {
        String capText = this.defaultKaptcha.createText();
        UUID uid = UUID.randomUUID();
        String uuid = uid.toString();
        this.commonService.storeCaptcha(uuid, capText);
        CaptchaTextDTO captchaDTO = new CaptchaTextDTO();
        captchaDTO.setText(capText);
        captchaDTO.setUid(uuid);
        return captchaDTO;
    }

    @Override
    public void createCaptchaPng(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String w = req.getParameter("w");
            String h = req.getParameter("h");
            BufferedImage buffImg = this.commonService.createImageCaptcha(w, h, req, resp);
            ServletOutputStream out = resp.getOutputStream();
            ImageIO.write((RenderedImage)buffImg, "png", (OutputStream)out);
            out.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getLoginType() {
        return "Unity";
    }

    @Override
    public Result<SsoUser> login(String username, String password, String tel, String uuid, String code, HttpServletRequest req) {
        List<ILoginService> loginServices = this.getLoginServices();
        Result<SsoUser> result = null;
        for (ILoginService loginService : loginServices) {
            try {
                result = loginService.login(username, password, tel, uuid, code, req);
                if (result != null && result.isSuccess()) {
                    return result;
                }
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getLoginType()), (Object)(result == null ? "" : result.getMessage()));
            }
            catch (Exception exception) {
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getLoginType()), (Throwable)exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        return this.login(username, password, "", uuid, code, req);
    }

    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser> result = this.login(username, password, null, null, null, null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        List<ILoginService> loginServices = this.getLoginServices();
        for (ILoginService loginService : loginServices) {
            loginService.loginOut(request, access_token);
        }
        return true;
    }

    private List<ILoginService> getLoginServices() {
        List<Object> loginTypes = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.sysLoginTypes)) {
            loginTypes.add("1");
        } else {
            loginTypes = Arrays.stream(this.sysLoginTypes.split(",")).collect(Collectors.toList());
        }
        List wholeBeans = SpringUtils.getBeansOfType(ILoginService.class);
        ArrayList<ILoginService> result = new ArrayList<ILoginService>();
        loginTypes.forEach(f -> {
            ILoginService loginService = wholeBeans.stream().filter(g -> g.getLoginType().equals(f)).findFirst().orElse(null);
            if (loginService != null) {
                result.add(loginService);
            }
        });
        return result;
    }
}

