/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.login.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.support.EncodeUtil;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.dto.OneLoginRequestData;
import com.geoway.design.biz.dto.OneLoginResponseData;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.login.IAppLoginService;
import com.geoway.design.biz.service.login.ISysLoginService;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppServiceImpl
implements IAppLoginService {
    @Value(value="${oneLogin.appId: }")
    private String appId;
    @Value(value="${oneLogin.appKey: }")
    private String appKey;
    @Value(value="${oneLogin.verifyURL: }")
    private String verifyURL;
    @Autowired
    SysUserMapper sysUserMapper;
    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    ISysLoginService sysLoginService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ResponseDataBase LoginAppByOneLogin(HttpServletRequest request, String processId, String token, String authCode) throws Exception {
        SysUser user;
        OneLoginResponseData respData;
        ResponseDataBase response = new ResponseDataBase();
        Long currentTime = System.currentTimeMillis();
        String sign = this.createSign(currentTime);
        OneLoginRequestData oneLoginParam = new OneLoginRequestData();
        oneLoginParam.setProcess_id(processId);
        oneLoginParam.setSign(sign);
        oneLoginParam.setToken(token);
        oneLoginParam.setTimestamp(currentTime);
        if (StrUtil.isNotBlank((CharSequence)authCode)) {
            oneLoginParam.setAuthCode(authCode);
        }
        if ((respData = this.vertifyAppOneLoginByHttpPost(oneLoginParam)).getStatus() == 200) {
            String phoneNumber = respData.getResult();
            user = this.querySysUserByPhone(phoneNumber);
            String tel = user.getTel();
            if (StrUtil.isBlank((CharSequence)tel)) {
                tel = user.getWorktel();
            }
        } else {
            throw new Exception("\u83b7\u53d6\u624b\u673a\u53f7\u7801\u5931\u8d25:" + respData.getStatus() + ":" + respData.getError_msg());
        }
        SysUserSecurity sysUserSecurity = (SysUserSecurity)this.sysUserSecurityMapper.selectById((Serializable)((Object)user.getId()));
        response = this.sysLoginService.checkLogin(user.getAccout(), sysUserSecurity.getPassword(), request);
        response.put((Object)"userName", (Object)user.getName());
        response.put((Object)"aliasName", (Object)user.getAname());
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OneLoginResponseData vertifyAppOneLoginByHttpPost(OneLoginRequestData oneLoginParam) throws RuntimeException {
        OneLoginResponseData respData = null;
        CloseableHttpClient httpclient = null;
        HttpPost httpPost = null;
        HttpEntity httpEntity = null;
        try {
            String body = JSONObject.toJSONString((Object)oneLoginParam);
            httpclient = HttpClients.createDefault();
            httpPost = new HttpPost(this.verifyURL);
            httpPost.addHeader("Accept", "*/*");
            httpPost.addHeader("content-Type", "application/json;charset=utf8");
            httpPost.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            httpEntity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            respData = (OneLoginResponseData)JSONObject.parseObject((String)content, OneLoginResponseData.class);
        }
        catch (Exception ex) {
            try {
                this.logger.error("HTTP\u8bf7\u6c42\u5931\u8d25:" + ex.getMessage());
                throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef\uff0c\u83b7\u53d6\u624b\u673a\u53f7\u7801\u5931\u8d25");
            }
            catch (Throwable throwable) {
                try {
                    if (httpEntity == null) throw throwable;
                    EntityUtils.consume(httpEntity);
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("HTTP\u8bf7\u6c42\u91ca\u653e\u8d44\u6e90\u5f02\u5e38:" + e.getMessage());
                }
                throw throwable;
            }
        }
        try {
            if (httpEntity == null) return respData;
            EntityUtils.consume((HttpEntity)httpEntity);
            return respData;
        }
        catch (Exception e) {
            this.logger.error("HTTP\u8bf7\u6c42\u91ca\u653e\u8d44\u6e90\u5f02\u5e38:" + e.getMessage());
            return respData;
        }
    }

    private SysUser querySysUserByPhone(String phoneNumber) throws Exception {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getTelEncrypt, (Object)AESUtils.encrypt((String)phoneNumber, (String)"FWAijk4A2Dwt2MKw"));
        queryWrapper.or();
        queryWrapper.eq(SysUser::getWorktel, (Object)AESUtils.encrypt((String)phoneNumber, (String)"FWAijk4A2Dwt2MKw"));
        List users = this.sysUserMapper.selectList((Wrapper)queryWrapper);
        if (users == null || users.size() == 0) {
            throw new Exception("\u6b64\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c");
        }
        SysUser user = (SysUser)users.get(0);
        return user;
    }

    private String createSign(Long currentTime) {
        String message = this.appId + "&&" + currentTime;
        return EncodeUtil.hmacSha256((String)message, (String)this.appKey);
    }
}

