/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysImage;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.mapper.ApplicationSysMapper;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.mapper.SysGroupMapper;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.service.sys.SysApplicationGroupService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApplicationSysServiceImpl
extends ServiceImpl<ApplicationSysMapper, SysApplication>
implements IApplicationSysService {
    @Autowired
    FunctionSysMapper functionSysMapper;
    @Autowired
    ApplicationSysMapper applicationSysMapper;
    @Autowired
    INsMenuService menuService;
    @Autowired
    IApplicationSysService.ISysImageService sysImageService;
    @Autowired
    SysGroupMapper sysGroupMapper;
    @Autowired
    SysApplicationGroupService sysApplicationGroupService;

    @Override
    public void saveOrUp(SysApplication sysApplication, String groupId, MultipartFile file) throws Exception {
        boolean flag;
        if (StringUtils.isEmpty((String)sysApplication.getName())) {
            throw new Exception("\u5e94\u7528\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((String)sysApplication.getId())) {
            wrapper.ne(SysApplication::getId, (Object)sysApplication.getId());
        }
        wrapper.eq(SysApplication::getName, (Object)sysApplication.getName());
        SysApplication one = (SysApplication)this.applicationSysMapper.selectOne((Wrapper)wrapper);
        if (one != null) {
            throw new Exception("\u5e94\u7528\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysApplication.getAppId())) {
            throw new Exception("\u5e94\u7528\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a\uff01");
        }
        wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((String)sysApplication.getId())) {
            wrapper.ne(SysApplication::getId, (Object)sysApplication.getId());
        }
        wrapper.eq(SysApplication::getAppId, (Object)sysApplication.getAppId());
        one = (SysApplication)this.applicationSysMapper.selectOne((Wrapper)wrapper);
        if (one != null) {
            throw new Exception("\u5e94\u7528\u6807\u8bc6\u3010" + one.getAppId() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysApplication.getId())) {
            int count = this.count();
            sysApplication.setSort(count);
        }
        if (!(flag = this.saveOrUpdate(sysApplication))) {
            throw new Exception("\u4fdd\u5b58\u5931\u8d25\uff01\uff01\uff01");
        }
        if (file != null && !file.isEmpty()) {
            SysImage sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysApplication.getImgid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysApplication.getId());
                sysImage.setType(2);
            }
            sysImage.setImage(file.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            if (StrUtil.isBlank((CharSequence)sysApplication.getImgid())) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysApplication::getImgid, (Object)sysImage.getId());
                updateWrapper.eq(SysApplication::getId, (Object)sysApplication.getId());
                this.update((Wrapper)updateWrapper);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)groupId)) {
            this.sysApplicationGroupService.saveApplicationGroup(sysApplication.getId(), groupId);
        }
    }

    @Override
    public void deleteApplication(String id) throws Exception {
        SysApplication sysApplication;
        int iCount;
        if (StringUtils.isEmpty((String)id)) {
            throw new Exception("\u4f20\u9012\u7684\u3010id\u3011\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper funcWrappers = Wrappers.lambdaQuery();
        funcWrappers.eq(SysFunction::getAppId, (Object)id);
        List<String> ids = this.functionSysMapper.selectList((Wrapper)funcWrappers).stream().map(map -> map.getId()).collect(Collectors.toList());
        if (ids.size() > 0 && (iCount = this.functionSysMapper.queryRelateMenesCount(ids)) > 0) {
            throw new Exception("\u5e94\u7528\u4e0b\u5b58\u5728\u6302\u63a5\u529f\u80fd\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        if (ids.size() > 0) {
            this.functionSysMapper.deleteBatchIds(ids);
            LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)update.in(SysMenu::getFunctionId, ids)).set(SysMenu::getType, (Object)0);
            this.menuService.update((Wrapper)update);
        }
        if ((sysApplication = (SysApplication)this.getById((Serializable)((Object)id))) != null && StrUtil.isNotBlank((CharSequence)sysApplication.getImgid())) {
            this.sysImageService.removeById((Serializable)((Object)sysApplication.getImgid()));
        }
        if (sysApplication != null) {
            this.sysApplicationGroupService.removeApplicationInGroup(sysApplication.getId());
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void deleteApplications(String ids) throws Exception {
        String[] idArr;
        if (StringUtils.isEmpty((String)ids)) {
            throw new Exception("\u4f20\u9012\u7684\u3010id\u3011\u4e3a\u7a7a\uff01");
        }
        for (String id : idArr = ids.split(",")) {
            this.deleteApplication(id);
        }
    }

    @Override
    public IPage<SysApplication> queryApplication(String params, Integer page, Integer size) throws Exception {
        if (StringUtils.isEmpty((String)params) && page == null) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.orderByDesc(SysApplication::getSort);
            int iCount = this.count();
            Page pages = new Page(1L, (long)iCount);
            return this.page((IPage)pages, (Wrapper)wrapper);
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(params, SysApplication.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public List<SysApplication> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysApplication.class);
        queryWrapper.orderByAsc((Object)"f_name");
        List sysApplications = ((ApplicationSysMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysApplications;
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(2);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)2);
        queryWrapper.eq(SysGroup::getName, (Object)group.getName());
        if (StrUtil.isBlank((CharSequence)group.getId())) {
            int icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.insert(group);
        } else {
            queryWrapper.ne(SysGroup::getId, (Object)group.getId());
            int icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.updateById(group);
        }
    }

    @Override
    public List<SysGroup> queryAppGroups() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)2);
        List groups = this.sysGroupMapper.selectList((Wrapper)queryWrapper);
        for (SysGroup group : groups) {
            group.setApplications(this.queryByGroupId(group.getId()));
        }
        return groups;
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        List<String> appIds = this.sysApplicationGroupService.queryGroupAppIds(groupId);
        if (appIds.size() > 0) {
            throw new Exception("\u5e94\u7528\u5206\u7ec4\u4e0b\u6709\u5173\u8054\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.sysGroupMapper.deleteById((Serializable)((Object)groupId));
    }

    @Override
    public int queryAppCount() {
        int count = 0;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)2);
        List groups = this.sysGroupMapper.selectList((Wrapper)queryWrapper);
        for (SysGroup group : groups) {
            count += this.sysApplicationGroupService.queryCount(group.getId());
        }
        return count;
    }

    @Override
    public List<SysApplication> queryAppNoGroup() {
        return this.applicationSysMapper.queryAppNoGroup();
    }

    private List<SysApplication> queryByGroupId(String groupId) {
        return this.applicationSysMapper.queryAppsByGroupId(groupId);
    }
}

