/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.BaseTreeUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.mapper.ApplicationSysMapper;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.service.dev.IUrlDynamicParameterService;
import com.geoway.design.biz.service.sys.INsMenuService;
import com.geoway.design.biz.vo.SysMenuVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NsMenuServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenu>
implements INsMenuService {
    final String rootPid = "1";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");
    @Autowired
    private FunctionSysMapper functionSysMapper;
    @Autowired
    private ApplicationSysMapper applicationSysMapper;
    @Autowired
    private IUrlDynamicParameterService urlDynamicParameterService;

    @Override
    public void saveOrUp(SysMenu menuSys) throws Exception {
        if (StringUtils.isEmpty((String)menuSys.getName())) {
            throw new Exception("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)menuSys.getKey())) {
            throw new Exception("\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, (Object)menuSys.getSystemId());
        if (StrUtil.isBlank((CharSequence)menuSys.getId())) {
            LambdaQueryWrapper countQueryWrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysMenu::getSystemId, (Object)menuSys.getSystemId());
            countQueryWrapper.eq(SysMenu::getPid, (Object)menuSys.getPid());
            Integer sort = this.count((Wrapper)countQueryWrapper) + 1;
            menuSys.setSort(sort);
        } else {
            wrapper.ne(SysMenu::getId, (Object)menuSys.getId());
        }
        wrapper.eq(SysMenu::getKey, (Object)menuSys.getKey());
        int iCountKey = this.count((Wrapper)wrapper);
        if (iCountKey > 0) {
            throw new Exception("\u83dc\u5355\u5173\u952e\u5b57:" + menuSys.getKey() + " \u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)menuSys.getId()) && !menuSys.getPid().equals("1")) {
            LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)update.eq(SysMenu::getId, (Object)menuSys.getPid())).set(SysMenu::getType, (Object)1);
            this.update((Wrapper)update);
        }
        this.saveOrUpdate(menuSys);
    }

    @Override
    public List<SysMenu> queryTree(String systemId, Integer flag, Integer group) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        String pid = "1";
        ((LambdaQueryWrapper)wrapper.eq(SysMenu::getPid, (Object)pid)).orderByAsc(SysMenu::getSort);
        if (StringUtils.isNotEmpty((String)systemId)) {
            wrapper.eq(SysMenu::getSystemId, (Object)systemId);
        }
        if (group != null) {
            wrapper.eq(SysMenu::getGroup, (Object)group);
        }
        List list = this.list((Wrapper)wrapper);
        return this.getTree(list, flag);
    }

    @Override
    public void deleteMenu(String id, String pid) throws Exception {
        SysMenu sysMenu;
        Integer count = this.count((Wrapper)new QueryWrapper().eq((Object)"f_pid", (Object)id));
        if (count > 0) {
            throw new Exception("\u5b58\u5728\u5b50\u83dc\u5355,\u65e0\u6cd5\u5220\u9664\uff01");
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)id)) {
            wrapper.eq((Object)"f_id", (Object)id);
        }
        if ((sysMenu = (SysMenu)this.getOne((Wrapper)wrapper)) != null && StrUtil.isNotEmpty((CharSequence)sysMenu.getFunctionId())) {
            throw new Exception("\u83dc\u5355\u5df2\u6302\u63a5\u529f\u80fd,\u65e0\u6cd5\u5220\u9664,\u8bf7\u53d6\u6d88\u6302\u63a5\u529f\u80fd\u518d\u8bd5\u8bd5\uff01");
        }
        ((SysMenuMapper)this.getBaseMapper()).delete((Wrapper)wrapper);
        if (!"1".equals(pid)) {
            LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)update.eq(SysMenu::getId, (Object)pid)).set(SysMenu::getType, (Object)0);
            this.update((Wrapper)update);
        }
    }

    @Override
    public void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception {
        SysMenu menu = (SysMenu)this.getById((Serializable)((Object)id));
        if (menu == null) {
            return;
        }
        sort = menu.getSort();
        int otherSort = sort;
        if (flag != null) {
            LambdaUpdateWrapper queryWrapper = Wrappers.lambdaUpdate();
            switch (flag) {
                case 1: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).orderByAsc(SysMenu::getSort)).last("limit 1");
                    SysMenu minInfo = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (minInfo != null && !minInfo.getSort().equals(sort)) {
                        Integer min = minInfo.getSort();
                        sort = sort - 1;
                        while (sort >= min) {
                            this.updateSort(pid, systemId, sort, sort + 1);
                            Integer n = sort;
                            Integer n2 = sort = Integer.valueOf(sort - 1);
                        }
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)min));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u9876\u4e86\uff01");
                }
                case 2: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).lt(SysMenu::getSort, (Object)sort)).orderByDesc(SysMenu::getSort);
                    SysMenu info = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (info != null && !info.getSort().equals(sort)) {
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)info.getSort()));
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)info.getId())).set(SysMenu::getSort, (Object)sort));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u9876\u4e86\uff01");
                }
                case 3: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).gt(SysMenu::getSort, (Object)sort)).orderByAsc(SysMenu::getSort);
                    SysMenu one = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (one != null && !one.getSort().equals(sort)) {
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)one.getSort()));
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)one.getId())).set(SysMenu::getSort, (Object)sort));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u5e95\u4e86\uff01");
                }
                case 4: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).orderByDesc(SysMenu::getSort)).last("limit 1");
                    SysMenu maxInfo = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (maxInfo != null && !maxInfo.getSort().equals(sort)) {
                        Integer max = maxInfo.getSort();
                        sort = sort + 1;
                        while (sort <= max) {
                            this.updateSort(pid, systemId, sort, sort - 1);
                            Integer n = sort;
                            Integer n3 = sort = Integer.valueOf(sort + 1);
                        }
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)max));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u5e95\u4e86\uff01");
                }
            }
        }
    }

    @Override
    public void updateType(String id, Integer type, String fid, Integer funType) {
        LambdaUpdateWrapper queryWrapper = new UpdateWrapper().lambda();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getId, (Object)id)).set(SysMenu::getType, (Object)type)).set(SysMenu::getFunctionId, (Object)fid)).set(SysMenu::getFuntype, (Object)funType);
        this.update((Wrapper)queryWrapper);
    }

    @Override
    public void updateDefault(String id, String sid) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)update.eq(SysMenu::getId, (Object)id)).set(SysMenu::getIsdefault, (Object)1);
        this.update((Wrapper)update);
        update.clear();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.eq(SysMenu::getIsdefault, (Object)1)).eq(SysMenu::getSystemId, (Object)sid)).ne(SysMenu::getId, (Object)id)).set(SysMenu::getIsdefault, (Object)0);
        this.update((Wrapper)update);
    }

    @Override
    public List<SysMenu> queryUserMenuTree(String userId, String systemId, Integer flag, Integer group) {
        List<SysMenu> menus = null;
        menus = StrUtil.isBlank((CharSequence)userId) ? ((SysMenuMapper)this.getBaseMapper()).querySystemMenuNoLogin(systemId, group) : ((SysMenuMapper)this.getBaseMapper()).queryUserSystemMenu(userId, systemId, group);
        ArrayList<String> allPids = new ArrayList<String>();
        this.queryAllPidsNoContains(menus, allPids);
        List allIds = menus.stream().map(menuItem -> menuItem.getId()).collect(Collectors.toList());
        List filterPids = allPids.stream().filter(pid -> !allIds.contains(pid)).collect(Collectors.toList());
        if (filterPids.size() > 0) {
            List pMenus = this.listByIds(filterPids);
            menus.addAll(pMenus);
        }
        ArrayList<SysApplication> applications = new ArrayList<SysApplication>();
        HashSet<SysMenu> menuSet = new HashSet<SysMenu>(menus);
        menus = new ArrayList<SysMenu>(menuSet);
        for (SysMenu menuSys : menus) {
            if (flag != 1 || !StringUtils.isNotEmpty((String)menuSys.getFunctionId())) continue;
            if (menuSys.getFuntype() != null && menuSys.getFuntype() == 2) {
                SysApplication app = (SysApplication)this.applicationSysMapper.selectById((Serializable)((Object)menuSys.getFunctionId()));
                applications.add(app);
                if (app == null) continue;
                menuSys.setUrl(this.urlDynamicParameterService.replace(app.getUrl()));
                continue;
            }
            SysFunction one = (SysFunction)this.functionSysMapper.selectById((Serializable)((Object)menuSys.getFunctionId()));
            menuSys.setFunctionInfo(one);
            if (one == null) continue;
            if (HttpUtil.isHttp((String)one.getUrl()) || HttpUtil.isHttps((String)one.getUrl())) {
                one.setUrl(this.urlDynamicParameterService.replace(one.getUrl()));
                menuSys.setUrl(one.getUrl());
                continue;
            }
            SysApplication application = applications.stream().filter(f -> f.getAppId().equals(one.getId())).findAny().orElse(null);
            if (application == null) {
                application = (SysApplication)this.applicationSysMapper.selectById((Serializable)((Object)one.getAppId()));
                applications.add(application);
                if (StringUtils.isNotEmpty((String)application.getUrl())) {
                    one.setUrl(application.getUrl() + one.getUrl());
                }
            }
            one.setUrl(this.urlDynamicParameterService.replace(one.getUrl()));
            menuSys.setUrl(one.getUrl());
        }
        List menuTrees = BaseTreeUtil.listToTree(menus, (TreeNodeConfig)this.treeNodeConfig, (String)"1");
        return menuTrees;
    }

    private void queryAllPidsNoContains(List<SysMenu> menus, List<String> pids) {
        ArrayList<String> newPids = new ArrayList<String>();
        for (SysMenu menu : menus) {
            boolean exists = StrUtil.isNotBlank((CharSequence)menu.getPid()) && !menu.getPid().equals("1");
            if (!exists || pids.contains(menu.getPid())) continue;
            newPids.add(menu.getPid());
        }
        pids.addAll(newPids);
        if (newPids.size() > 0) {
            List pMenus = this.listByIds(newPids);
            this.queryAllPidsNoContains(pMenus, pids);
        }
    }

    @Override
    public List<Tree<String>> getSysMenuVoTree(List<String> roleIdList) {
        ArrayList<Tree<String>> treeList = new ArrayList<Tree<String>>();
        List<SysMenuVO> sysMenuVOList = ((SysMenuMapper)this.baseMapper).getSysMenuVO(roleIdList);
        if (ObjectUtil.isNotEmpty(sysMenuVOList)) {
            return BaseTreeUtil.ListBuildTree(sysMenuVOList, SysMenuVO.class, (TreeNodeConfig)this.treeNodeConfig, (String)"1");
        }
        return treeList;
    }

    @Override
    public SysMenu queryMenuByKey(String menuKey, String systemId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, (Object)systemId);
        wrapper.eq(SysMenu::getKey, (Object)menuKey);
        wrapper.last("LIMIT 1");
        SysMenu menu = (SysMenu)this.getOne((Wrapper)wrapper);
        if (menu != null) {
            if (menu.getLevel() == 1) {
                menu.setRootId(menu.getId());
            } else if (menu.getLevel() == 2) {
                menu.setRootId(menu.getPid());
            } else if (menu.getLevel() == 3) {
                SysMenu pMenu = (SysMenu)this.getById((Serializable)((Object)menu.getPid()));
                menu.setRootId(pMenu.getPid());
            }
        }
        return menu;
    }

    private List<SysMenu> bulidTree(Set<SysMenu> menus) {
        int minLevel = 99;
        HashMap mapParam = new HashMap();
        for (SysMenu menu : menus) {
            String key = menu.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(menu);
                } else {
                    ArrayList<SysMenu> childList = new ArrayList<SysMenu>();
                    childList.add(menu);
                    mapParam.put(key, childList);
                }
            }
            if (menu.getLevel() >= minLevel) continue;
            minLevel = menu.getLevel();
        }
        ArrayList<SysMenu> results = new ArrayList<SysMenu>();
        for (SysMenu menu : menus) {
            String key = menu.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                List<SysMenu> child = this.menuSort((List)mapParam.get(key));
                menu.setChildren(child);
            }
            if (menu.getLevel() != minLevel) continue;
            results.add(menu);
        }
        return this.menuSort(results);
    }

    private void updateSort(String pid, String systemId, Integer sort, Integer value) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).eq(SysMenu::getSort, (Object)sort)).set(SysMenu::getSort, (Object)value);
        this.update((Wrapper)update);
    }

    private List<SysMenu> getTree(List<SysMenu> list, Integer flag) {
        for (SysMenu menuSys : list) {
            List children;
            if (flag == 1 && StringUtils.isNotEmpty((String)menuSys.getFunctionId())) {
                SysFunction one = (SysFunction)this.functionSysMapper.selectById((Serializable)((Object)menuSys.getFunctionId()));
                menuSys.setFunctionInfo(one);
            }
            if ((children = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"f_pid", (Object)menuSys.getId())).orderByAsc((Object)"f_sort"))).size() <= 0) continue;
            menuSys.setChildren(this.getTree(children, flag));
        }
        return list;
    }

    private List<SysMenu> menuSort(List<SysMenu> menuList) {
        Collections.sort(menuList, new Comparator<SysMenu>(){

            @Override
            public int compare(SysMenu menu1, SysMenu menu2) {
                int flag = menu1.getLevel() - menu2.getLevel();
                if (flag == 0) {
                    flag = menu1.getSort() - menu2.getSort();
                }
                return flag;
            }
        });
        return menuList;
    }
}

