/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.NsSystemStyle;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysImage;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.entity.SysPermissonSystem;
import com.geoway.design.biz.mapper.NsSystemMapper;
import com.geoway.design.biz.mapper.SysGroupMapper;
import com.geoway.design.biz.mapper.SysMenuMapper;
import com.geoway.design.biz.mapper.SysPermissionSystemMapper;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.INsSystemService;
import com.geoway.design.biz.service.sys.impl.NsMenuServiceImpl;
import com.geoway.design.biz.service.sys.impl.NsSystemStyleServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NsSystemServiceImpl
extends ServiceImpl<NsSystemMapper, SysNsSystem>
implements INsSystemService {
    @Autowired
    private NsSystemMapper systemMapper;
    @Autowired
    private SysMenuMapper menuMapper;
    @Autowired
    private NsMenuServiceImpl menuService;
    @Autowired
    private ProjectConfig config;
    @Autowired
    private NsSystemStyleServiceImpl styleService;
    @Autowired
    IApplicationSysService.ISysImageService sysImageService;
    @Autowired
    SysGroupMapper sysGroupMapper;
    @Autowired
    SysPermissionSystemMapper sysPermissionSystemMapper;

    @Override
    public void saveOrUp(SysNsSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception {
        LambdaUpdateWrapper updateWrapper;
        SysImage sysImage;
        SysNsSystem one;
        if (StringUtils.isEmpty((String)sysNsSystem.getName())) {
            throw new Exception("\u3010\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysNsSystem::getName, (Object)sysNsSystem.getName());
        if (StringUtils.isNotEmpty((String)sysNsSystem.getId())) {
            wrapper.ne(SysNsSystem::getId, (Object)sysNsSystem.getId());
        }
        if ((one = (SysNsSystem)this.getOne((Wrapper)wrapper)) != null) {
            throw new Exception("\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getStyleId())) {
            throw new Exception("\u3010\u4e3b\u9898\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getKey())) {
            throw new Exception("\u3010\u5173\u952e\u5b57\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysNsSystem::getKey, (Object)sysNsSystem.getKey());
        if (StringUtils.isNotEmpty((String)sysNsSystem.getId())) {
            wrapper.ne(SysNsSystem::getId, (Object)sysNsSystem.getId());
        }
        if ((one = (SysNsSystem)this.getOne((Wrapper)wrapper)) != null) {
            throw new Exception("\u5173\u952e\u5b57\u3010" + one.getKey() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((String)sysNsSystem.getId())) {
            int cur = this.count();
            sysNsSystem.setSort(++cur);
            sysNsSystem.setUpDateTime(new Date());
        } else {
            sysNsSystem.setSort(sysNsSystem.getSort());
            sysNsSystem.setUpDateTime(sysNsSystem.getUpDateTime());
        }
        SysNsSystem exsitSystem = (SysNsSystem)this.getById((Serializable)((Object)sysNsSystem.getId()));
        this.saveOrUpdate(sysNsSystem);
        if (logofile != null && !logofile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getLogoid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(logofile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            if (StrUtil.isBlank((CharSequence)sysNsSystem.getLogoid())) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getLogoid, (Object)sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId, (Object)sysNsSystem.getId());
                this.update((Wrapper)updateWrapper);
            }
        } else if (StrUtil.isBlankIfStr((Object)sysNsSystem.getLogoid()) && exsitSystem != null && StrUtil.isNotBlank((CharSequence)exsitSystem.getLogoid())) {
            this.sysImageService.removeById((Serializable)((Object)exsitSystem.getLogoid()));
        }
        if (bgfile != null && !bgfile.isEmpty()) {
            sysImage = (SysImage)this.sysImageService.getById((Serializable)((Object)sysNsSystem.getBgid()));
            if (sysImage == null) {
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }
            sysImage.setImage(bgfile.getBytes());
            this.sysImageService.saveOrUpdate(sysImage);
            if (StrUtil.isBlank((CharSequence)sysNsSystem.getBgid())) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysNsSystem::getBgid, (Object)sysImage.getId());
                updateWrapper.eq(SysNsSystem::getId, (Object)sysNsSystem.getId());
                this.update((Wrapper)updateWrapper);
            }
        } else if (StrUtil.isBlankIfStr((Object)sysNsSystem.getBgid()) && exsitSystem != null && StrUtil.isNotBlank((CharSequence)exsitSystem.getBgid())) {
            this.sysImageService.removeById((Serializable)((Object)exsitSystem.getBgid()));
        }
    }

    @Override
    public void deleteSystem(String id) {
        SysNsSystem sysNsSystem = (SysNsSystem)this.getById((Serializable)((Object)id));
        if (sysNsSystem != null && StrUtil.isNotBlank((CharSequence)sysNsSystem.getLogoid())) {
            this.sysImageService.removeById((Serializable)((Object)sysNsSystem.getLogoid()));
        }
        if (sysNsSystem != null && StrUtil.isNotBlank((CharSequence)sysNsSystem.getBgid())) {
            this.sysImageService.removeById((Serializable)((Object)sysNsSystem.getBgid()));
        }
        this.removeById((Serializable)((Object)id));
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysMenu::getSystemId, (Object)sysNsSystem.getId());
        this.menuMapper.delete((Wrapper)menuWrapper);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysPermissonSystem::getSystemid, (Object)sysNsSystem.getId());
        this.sysPermissionSystemMapper.delete((Wrapper)queryWrapper2);
    }

    @Override
    public void deleteSystems(String ids) {
        String[] idArr;
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        for (String id : idArr = ids.split(",")) {
            this.deleteSystem(id);
        }
    }

    @Override
    public HashMap<String, Object> queryInfo(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                List<SysMenu> sysMenus = this.menuService.queryTree(sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = this.menuService.queryTree(sysNsSystem.getId(), 1, 1);
                map.put("system", sysNsSystem);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysNsSystem> queryList() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysNsSystem::getSort);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<SysNsSystem> queryAll() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysNsSystem::getSort);
        List list = this.list((Wrapper)wrapper);
        for (SysNsSystem sysNsSystem : list) {
            List<SysMenu> sysMenus = this.menuService.queryTree(sysNsSystem.getId(), 0, 0);
            List<SysMenu> userMenus = this.menuService.queryTree(sysNsSystem.getId(), 0, 1);
            sysNsSystem.setSysMenu(sysMenus);
            sysNsSystem.setUCenterMenu(userMenus);
        }
        return list;
    }

    @Override
    public void stateUp(String id, Integer state) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)update.eq(SysNsSystem::getId, (Object)id)).set(SysNsSystem::getState, (Object)state);
        this.update((Wrapper)update);
    }

    @Override
    public HashMap<String, Object> querySystemInfoByUser(String userId, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                NsSystemStyle systemStyle = this.styleService.findOne(sysNsSystem.getStyleId());
                List<SysMenu> sysMenus = this.menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 0);
                List<SysMenu> uCenterMenu = this.menuService.queryUserMenuTree(userId, sysNsSystem.getId(), 1, 1);
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
                map.put("menu", sysMenus);
                map.put("uCenterMenu", uCenterMenu);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public HashMap<String, Object> querySystemBaseInfoByKey(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)key)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(SysNsSystem::getKey, (Object)key)).eq(SysNsSystem::getState, (Object)1);
            wrapper.last(" limit 1");
            SysNsSystem sysNsSystem = (SysNsSystem)this.getOne((Wrapper)wrapper);
            if (sysNsSystem != null) {
                NsSystemStyle systemStyle = this.styleService.findOne(sysNsSystem.getStyleId());
                map.put("system", sysNsSystem);
                map.put("systemStyle", systemStyle);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Override
    public List<SysNsSystem> querySystemListByUser(String userId) {
        if (StrUtil.isBlank((CharSequence)userId)) {
            return null;
        }
        List sysNsSystems = null;
        List<String> sysIds = this.menuMapper.queryUserMenuSystemId(userId);
        if (sysIds.size() > 0) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.in(SysNsSystem::getId, sysIds)).orderBy(true, true, (Object[])new SFunction[]{SysNsSystem::getSort});
            sysNsSystems = this.systemMapper.selectList((Wrapper)wrapper);
        }
        return sysNsSystems;
    }

    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(1);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)1);
        queryWrapper.eq(SysGroup::getName, (Object)group.getName());
        if (StrUtil.isBlank((CharSequence)group.getId())) {
            int icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.insert(group);
        } else {
            queryWrapper.ne(SysGroup::getId, (Object)group.getId());
            int icount = this.sysGroupMapper.selectCount((Wrapper)queryWrapper);
            if (icount > 0) {
                throw new Exception("\u5206\u7ec4\u540d\u79f0: \u3010" + group.getName() + "\u3011 \u5df2\u5b58\u5728");
            }
            this.sysGroupMapper.updateById(group);
        }
    }

    @Override
    public List<SysGroup> querySystemGroups() throws Exception {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType, (Object)1);
        List groups = this.sysGroupMapper.selectList((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        for (SysGroup group : groups) {
            queryWrapper2.clear();
            queryWrapper2.eq(SysNsSystem::getGroupId, (Object)group.getId());
            List systems = this.list((Wrapper)queryWrapper2);
            group.setSystems(systems);
        }
        List<SysNsSystem> unGroupSystems = this.querySystemNoGroup();
        if (unGroupSystems.size() > 0) {
            SysGroup group;
            group = new SysGroup();
            group.setId("weifenzu");
            group.setName("\u672a\u5206\u7ec4");
            group.setType(1);
            group.setSystems(unGroupSystems);
            groups.add(group);
        }
        return groups;
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNsSystem::getGroupId, (Object)groupId);
        int icount = this.count((Wrapper)queryWrapper);
        if (icount > 0) {
            throw new Exception("\u5e94\u7528\u5206\u7ec4\u4e0b\u6709\u5173\u8054\u7cfb\u7edf\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.sysGroupMapper.deleteById((Serializable)((Object)groupId));
    }

    @Override
    public List<SysNsSystem> querySystemNoGroup() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.isNull(SysNsSystem::getGroupId);
        return this.list((Wrapper)queryWrapper);
    }
}

