/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysPermissionFunction;
import com.geoway.design.biz.entity.SysPermissonApplication;
import com.geoway.design.biz.mapper.FunctionSysMapper;
import com.geoway.design.biz.mapper.SysPermissionApplicationMapper;
import com.geoway.design.biz.mapper.SysPermissionFunctionMapper;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import com.geoway.design.biz.service.sys.ISysPermissionApplicationService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionApplicationServiceImpl
extends ServiceImpl<SysPermissionApplicationMapper, SysPermissonApplication>
implements ISysPermissionApplicationService {
    @Autowired
    IApplicationSysService applicationSysService;
    @Autowired
    SysPermissionFunctionMapper sysPermissionFunctionMapper;
    @Autowired
    FunctionSysMapper functionSysMapper;

    @Override
    public List<SysApplication> queryByPermissionId(String permissionId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonApplication::getPermissionid, (Object)permissionId);
        List roleSystems = this.list((Wrapper)wrapper);
        List systemIds = roleSystems.stream().map(f -> f.getApplicationid()).collect(Collectors.toList());
        if (systemIds.size() == 0) {
            return new ArrayList<SysApplication>();
        }
        return this.applicationSysService.listByIds(systemIds);
    }

    @Override
    public void delete(String permissionId, String appId) {
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysFunction::getAppId, (Object)appId);
        List sysFunctions = this.functionSysMapper.selectList((Wrapper)queryWrapper2);
        List functionsIds = sysFunctions.stream().map(i -> i.getId()).collect(Collectors.toList());
        if (functionsIds.size() > 0) {
            LambdaQueryWrapper queryWrapper3 = Wrappers.lambdaQuery();
            queryWrapper3.eq(SysPermissionFunction::getPermissionid, (Object)permissionId);
            queryWrapper3.in(SysPermissionFunction::getFuncid, functionsIds);
            this.sysPermissionFunctionMapper.delete((Wrapper)queryWrapper3);
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(SysPermissonApplication::getPermissionid, (Object)permissionId)).eq(SysPermissonApplication::getApplicationid, (Object)appId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void batchDelete(String permissionId, List<String> systemIds) {
        for (String systemId : systemIds) {
            this.delete(permissionId, systemId);
        }
    }

    @Override
    public void batchSave(String permissionId, List<String> applicationIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysPermissonApplication::getPermissionid, (Object)permissionId);
        this.remove((Wrapper)wrapper);
        ArrayList applications = new ArrayList();
        applicationIds.forEach(f -> {
            SysPermissonApplication sys = new SysPermissonApplication();
            sys.setPermissionid(permissionId);
            sys.setApplicationid((String)f);
            applications.add(sys);
        });
        this.saveBatch(applications);
    }
}

