/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysXzqRegion;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysXzqRegionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRegionServiceImpl
extends ServiceImpl<SysRegionMapper, SysRegion>
implements ISysRegionService {
    @Autowired
    ISysXzqRegionService sysXzqRegionService;

    @Override
    public void saveOrUp(SysRegion region) throws Exception {
        int iCount;
        if (StrUtil.isBlank((CharSequence)region.getCode())) {
            region.setCode(region.getRegionCode());
        }
        if (StrUtil.isBlank((CharSequence)region.getRegionCode())) {
            region.setRegionCode(region.getCode());
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRegion::getCode, (Object)region.getCode());
        if (StrUtil.isNotBlank((CharSequence)region.getId())) {
            wrapper.ne(SysRegion::getId, (Object)region.getId());
        }
        if ((iCount = this.count((Wrapper)wrapper)) > 0) {
            throw new Exception("\u8f96\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        }
        wrapper.clear();
        wrapper.eq(SysRegion::getCode, (Object)region.getPcode());
        wrapper.last(" limit 1 ");
        SysRegion pRegion = (SysRegion)this.getOne((Wrapper)wrapper);
        int level = pRegion == null ? 1 : pRegion.getLevel() + 1;
        region.setLevel(level);
        this.saveOrUpdate(region);
    }

    @Override
    public List<SysRegion> queryTree(String filterParam, String sortParam) throws Exception {
        List<SysRegion> regions = this.queryList(filterParam, sortParam);
        return this.constructTree(regions);
    }

    @Override
    public List<SysRegion> queryList(String filterParam, String sortParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysRegion.class);
        List regions = this.list((Wrapper)queryWrapper);
        return regions;
    }

    @Override
    public List<SysRegion> queryRegionListByCode(String regionCode) {
        List<SysRegion> children = ((SysRegionMapper)this.baseMapper).getRegionListByCode(regionCode);
        Collections.reverse(children);
        return children;
    }

    @Override
    public List<SysRegion> queryAllParentRegion(String regionCode) {
        List<SysRegion> result = ((SysRegionMapper)this.baseMapper).getAllParentRegion(regionCode);
        Collections.reverse(result);
        return result;
    }

    @Override
    public IPage<SysRegion> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRegion.class);
        Page pages = new Page((long)page, (long)size);
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteTree(id);
        }
    }

    @Override
    public SysRegion findOne(String id, String filterParam) throws Exception {
        SysRegion region = (SysRegion)this.getById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pcode_EQ_" + region.getCode();
        List<SysRegion> childrens = this.queryList(filterParam, "SORT_code_ASC");
        region.setChildren(childrens);
        return region;
    }

    @Override
    public List<SysRegion> registerRegionByXzq(String rootRegionCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysXzqRegion::getCode, (Object)rootRegionCode);
        SysXzqRegion rootRegion = (SysXzqRegion)this.sysXzqRegionService.getOne((Wrapper)wrapper);
        String matchCode = rootRegionCode;
        if (rootRegion.getLevel() == 1) {
            matchCode = rootRegionCode.substring(0, 2);
        } else if (rootRegion.getLevel() == 2) {
            matchCode = rootRegionCode.substring(0, 4);
        } else if (rootRegion.getLevel() == 3) {
            matchCode = rootRegionCode.substring(0, 6);
        } else if (rootRegion.getLevel() == 4) {
            matchCode = rootRegionCode.substring(0, 9);
        }
        wrapper.clear();
        wrapper.likeRight(SysXzqRegion::getCode, (Object)matchCode);
        wrapper.orderByAsc((Object[])new SFunction[]{SysXzqRegion::getCode, SysXzqRegion::getLevel});
        List xzqRegions = this.sysXzqRegionService.list((Wrapper)wrapper);
        LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
        wrapper2.likeRight(SysRegion::getCode, (Object)matchCode);
        this.remove((Wrapper)wrapper2);
        SysRegion region = null;
        ArrayList<SysRegion> regions = new ArrayList<SysRegion>();
        int minusLevel = rootRegion.getLevel();
        for (SysXzqRegion xzqRegion : xzqRegions) {
            region = new SysRegion();
            BeanUtils.copyProperties((Object)xzqRegion, (Object)region);
            region.setRegionCode(xzqRegion.getCode());
            int level = xzqRegion.getLevel() - minusLevel + 1;
            region.setLevel(level);
            regions.add(region);
        }
        this.saveBatch(regions);
        return this.constructTree(regions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excelOutput(OutputStream outputStream, String rootRegionCode) throws IOException {
        ExcelWriter excelWriter = null;
        try {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysXzqRegion::getCode, (Object)rootRegionCode);
            SysXzqRegion rootRegion = (SysXzqRegion)this.sysXzqRegionService.getOne((Wrapper)wrapper);
            String matchCode = rootRegionCode;
            if (rootRegion.getLevel() == 1) {
                matchCode = rootRegionCode.substring(0, 2);
            } else if (rootRegion.getLevel() == 2) {
                matchCode = rootRegionCode.substring(0, 4);
            } else if (rootRegion.getLevel() == 3) {
                matchCode = rootRegionCode.substring(0, 6);
            } else if (rootRegion.getLevel() == 4) {
                matchCode = rootRegionCode.substring(0, 8);
            }
            wrapper.clear();
            wrapper.likeRight(SysXzqRegion::getCode, (Object)matchCode);
            wrapper.orderByAsc((Object[])new SFunction[]{SysXzqRegion::getCode, SysXzqRegion::getLevel});
            List xzqRegions = this.sysXzqRegionService.list((Wrapper)wrapper);
            ArrayList excelObjects = new ArrayList();
            for (SysXzqRegion sysXzqRegion : xzqRegions) {
                LinkedHashMap<String, String> excelObject = new LinkedHashMap<String, String>();
                excelObject.put("\u884c\u653f\u533a\u540d\u79f0", sysXzqRegion.getName());
                excelObject.put("\u884c\u653f\u533a\u4ee3\u7801", sysXzqRegion.getCode());
                excelObject.put("\u7236\u7ea7\u884c\u653f\u533a\u4ee3\u7801", sysXzqRegion.getPcode());
                if (sysXzqRegion.getLevel() == 1) {
                    excelObject.put("\u884c\u653f\u533a\u7ea7\u522b", "\u7701");
                } else if (sysXzqRegion.getLevel() == 2) {
                    excelObject.put("\u884c\u653f\u533a\u7ea7\u522b", "\u5e02");
                } else if (sysXzqRegion.getLevel() == 3) {
                    excelObject.put("\u884c\u653f\u533a\u7ea7\u522b", "\u53bf");
                } else if (sysXzqRegion.getLevel() == 4) {
                    excelObject.put("\u884c\u653f\u533a\u7ea7\u522b", "\u4e61\u9547");
                } else if (sysXzqRegion.getLevel() == 5) {
                    excelObject.put("\u884c\u653f\u533a\u7ea7\u522b", "\u6751");
                }
                excelObjects.add(excelObject);
            }
            excelWriter = ExcelUtil.getWriter();
            excelWriter.write(excelObjects);
            excelWriter.flush(outputStream, true);
        }
        catch (Exception ex) {
            this.log.error(DateUtil.now() + " \u8f96\u533a\u5bfc\u51fa\uff0cExcel\u5f02\u5e38\uff1a" + ex.getMessage());
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    public List<SysRegion> queryUserRegions(String userId) {
        return ((SysRegionMapper)this.baseMapper).queryUserRegions(userId);
    }

    @Override
    public void excelImport(InputStream stream) {
        try {
            ExcelReader excelReader = ExcelUtil.getReader((InputStream)stream, (int)0);
            List excelList = excelReader.read(1);
            ArrayList<SysXzqRegion> sysRegionList = new ArrayList<SysXzqRegion>();
            for (List excelObject : excelList) {
                SysXzqRegion sysRegion = new SysXzqRegion();
                String name = excelObject.get(0).toString();
                String code = excelObject.get(1).toString();
                String pCode = excelObject.get(2).toString();
                String level = excelObject.get(3).toString();
                sysRegion.setName(name);
                sysRegion.setCode(code);
                switch (level) {
                    case "\u7701": {
                        sysRegion.setLevel(1);
                        break;
                    }
                    case "\u5e02": {
                        sysRegion.setLevel(2);
                        break;
                    }
                    case "\u53bf": {
                        sysRegion.setLevel(3);
                        break;
                    }
                    case "\u4e61\u9547": {
                        sysRegion.setLevel(4);
                        break;
                    }
                    case "\u6751": {
                        sysRegion.setLevel(5);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u884c\u653f\u533a\u5212\u7ea7\u522b\u8bbe\u7f6e\u6709\u8bef\uff01");
                    }
                }
                sysRegion.setPcode(pCode);
                sysRegionList.add(sysRegion);
            }
            for (SysXzqRegion sysXzqRegion : sysRegionList) {
                this.sysXzqRegionService.saveOrUpdate(sysXzqRegion, (Wrapper)Wrappers.lambdaQuery(SysXzqRegion.class).eq(SysXzqRegion::getCode, (Object)sysXzqRegion.getCode()));
            }
            Collections.sort(sysRegionList, (o1, o2) -> o1.getLevel() - o2.getLevel());
            this.registerRegionByXzq(((SysXzqRegion)sysRegionList.get(0)).getCode());
        }
        catch (Exception ex) {
            throw new RuntimeException("\u5bfc\u5165\u884c\u653f\u533a\u5212\u5931\u8d25");
        }
    }

    private String getPCode(String level, String code) {
        String parentCode = "";
        switch (level) {
            case "\u7701": {
                return "-1";
            }
            case "\u5e02": {
                parentCode = code.substring(0, 2);
                parentCode = parentCode + StrUtil.repeat((char)'0', (int)(code.length() - 2));
                break;
            }
            case "\u53bf": {
                parentCode = code.substring(0, 4);
                parentCode = parentCode + StrUtil.repeat((char)'0', (int)(code.length() - 4));
                break;
            }
            case "\u4e61\u9547": {
                parentCode = code.substring(0, 6);
                parentCode = parentCode + StrUtil.repeat((char)'0', (int)(code.length() - 6));
                break;
            }
            case "\u6751": {
                parentCode = code.substring(0, 8);
                parentCode = parentCode + StrUtil.repeat((char)'0', (int)(code.length() - 9));
                break;
            }
            default: {
                throw new RuntimeException("\u884c\u653f\u533a\u5212\u7ea7\u522b\u8bbe\u7f6e\u6709\u8bef\uff01");
            }
        }
        return parentCode;
    }

    private void deleteTree(String id) {
        String rootRegionCode;
        SysRegion region = (SysRegion)this.getById((Serializable)((Object)id));
        if (region == null || StrUtil.isBlank((CharSequence)region.getCode())) {
            return;
        }
        String matchCode = rootRegionCode = region.getCode();
        if (region.getLevel() == 1) {
            matchCode = rootRegionCode.substring(0, 2);
        } else if (region.getLevel() == 2) {
            matchCode = rootRegionCode.substring(0, 4);
        } else if (region.getLevel() == 3) {
            matchCode = rootRegionCode.substring(0, 6);
        } else if (region.getLevel() == 4) {
            matchCode = rootRegionCode.substring(0, 9);
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.likeRight(SysRegion::getCode, (Object)matchCode);
        this.remove((Wrapper)wrapper);
    }

    private List<SysRegion> constructTree(List<SysRegion> list) {
        int minLevel = 9;
        HashMap mapParam = new HashMap();
        for (SysRegion region : list) {
            String key = region.getPcode();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(region);
                } else {
                    ArrayList<SysRegion> childList = new ArrayList<SysRegion>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }
            if (region.getLevel() >= minLevel) continue;
            minLevel = region.getLevel();
        }
        ArrayList<SysRegion> results = new ArrayList<SysRegion>();
        for (SysRegion region : list) {
            String key = region.getCode();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                region.setChildren((List)mapParam.get(key));
            }
            if (region.getLevel() != minLevel) continue;
            results.add(region);
        }
        return results;
    }
}

