/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysUserRole;
import com.geoway.design.biz.mapper.SysUserRoleMapper;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.vo.SysRoleVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    @Override
    @OpLog(name="\u4fee\u6539\u7528\u6237\u6240\u5c5e\u89d2\u8272", opType=OpLog.OpType.update)
    public void updateUserRole(String userId, List<String> roleIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getUserid, (Object)userId);
        this.remove((Wrapper)wrapper);
        if (roleIds == null) {
            return;
        }
        ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
        for (String roleId : roleIds) {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);
            userRoles.add(userRole);
        }
        if (userRoles.size() > 0) {
            this.saveBatch(userRoles);
        }
    }

    @Override
    public void updateRoleUsers(String roleId, List<String> userIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        this.remove((Wrapper)wrapper);
        ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
        for (String userId : userIds) {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);
            userRoles.add(userRole);
        }
        if (userRoles.size() > 0) {
            this.saveBatch(userRoles);
        }
    }

    @Override
    public Map<String, String> queryRoleByIds(List<String> ids) {
        List<SysRoleVO> sysRoleVOS = ((SysUserRoleMapper)this.baseMapper).queryRole(ids);
        return sysRoleVOS.stream().collect(Collectors.toMap(SysRoleVO::getId, SysRoleVO::getName));
    }
}

