/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.entity.SysXzqRegion;
import com.geoway.design.biz.mapper.SysXzqRegionMapper;
import com.geoway.design.biz.service.sys.ISysXzqRegionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysXzqRegionServiceImpl
extends ServiceImpl<SysXzqRegionMapper, SysXzqRegion>
implements ISysXzqRegionService {
    @Override
    public List<SysXzqRegion> queryList(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysXzqRegion.class);
        queryWrapper.orderByAsc((Object)"code");
        List regions = this.list((Wrapper)queryWrapper);
        return regions;
    }

    @Override
    public List<SysXzqRegion> queryRegionTree(String filterParam) throws Exception {
        List<SysXzqRegion> regions = this.queryList(filterParam);
        return this.constructTree(regions);
    }

    private List<SysXzqRegion> constructTree(List<SysXzqRegion> list) {
        int minLevel = 9;
        HashMap mapParam = new HashMap();
        for (SysXzqRegion region : list) {
            String key = region.getPcode();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(region);
                } else {
                    ArrayList<SysXzqRegion> childList = new ArrayList<SysXzqRegion>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }
            if (region.getLevel() >= minLevel) continue;
            minLevel = region.getLevel();
        }
        if (minLevel < 1) {
            minLevel = 1;
        }
        ArrayList<SysXzqRegion> results = new ArrayList<SysXzqRegion>();
        for (SysXzqRegion region : list) {
            String key = region.getCode();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                region.setChildren((List)mapParam.get(key));
            }
            if (region.getLevel() != minLevel) continue;
            results.add(region);
        }
        return results;
    }
}

