/**
 *
 */
package com.geoway.design.biz.annotation;

import java.lang.annotation.*;

/**
 * 日志拦截AOP
 * @author daidd
 *
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface OpLog {
    /**
     * 模块名称
     */

    String name() default "";

    /**
     * 日志内容
     */
    String detail() default "";

    /**
     * 操作类别
     */
    OpType opType() default OpType.search;

    ;

    /**
     * 系统标识
     */
    SystemType systemId() default SystemType.sso;

    enum OpType {
        search, add, update, del, login, loginout
    }

    ;

    enum SystemType {
        sso, menhu, yunwei
    }
}
