package com.geoway.design.biz.aspect;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.design.base.support.RedisUtil;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.SysOplogService;
import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 接口日志保存切面方法
 */
@Slf4j
@Aspect
@Service
@SuppressWarnings("all")
public class OpLogAspect {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SysOplogService sysOplogService;

    @Autowired
    IOauth2Service oauth2Service;

    @Value("${sso.app.id}")
    private String appId;

    /**
     *  配置织入点
     */
    @Pointcut("@annotation(com.geoway.design.biz.annotation.OpLog)")
    public void logPointCut() {
    }

    @Before("logPointCut()")
    public void beforeExec(JoinPoint joinPoint) {
        OpLog opLog = getAnnotationLog(joinPoint);
        if(opLog.opType().equals(opLog.opType().loginout)){
            this.afterExec(joinPoint,null);
        }
    }

    @SuppressWarnings("rawtypes")
    @AfterReturning(pointcut = "logPointCut()", returning = "rvt")
    public void afterExec(JoinPoint joinPoint, Object rvt) {
        try {
            HttpServletRequest request =
                    ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            OpLog opLog = getAnnotationLog(joinPoint);
            if (opLog == null) {
                return;
            }
            SsoUser sysUser = SessionUtils.getUser(request,null);
            if(sysUser == null){
                sysUser = oauth2Service.queryCurrentSsoUser(request);
            }
            if(sysUser == null){
                log.error("************未获取到当前用户信息************");
                return;
            }
            String methodName = joinPoint.getSignature().getName();
            String typeName = joinPoint.getSignature().getDeclaringTypeName();
            int begin = typeName.lastIndexOf(".") + 1;


            String methodFullName = typeName.substring(begin) + "." + methodName;
            Map<String,String[]> map = request.getParameterMap();
            Map<String,String> newParamsMap = new LinkedHashMap<>();
            for(String key: map.keySet()){
                String newVal = ArrayUtil.join(map.get(key),",");
                newParamsMap.put(key,newVal);
            }

            String params = JSON.toJSONString(newParamsMap);
            SysOplog sysOplog = new SysOplog();
            sysOplog.setName(opLog.name());
            sysOplog.setDetail(opLog.detail());
            sysOplog.setOptype(opLog.opType().toString());
            sysOplog.setMethod(methodFullName);
            sysOplog.setParam(params);
            sysOplog.setCreatetime(new Date());
            String ip =  ServletUtil.getClientIP(request);
            sysOplog.setMachineName(getMachineName(request));
            sysOplog.setIp(ip);
            sysOplog.setSystemid("1");
            sysOplog.setUserid(sysUser.getId());
            sysOplog.setUsername(sysUser.getUserName());
            String appIdNew = this.appId;
            if(newParamsMap.containsKey(Oauth2Constant.APP_ID)){
                appIdNew = newParamsMap.get(Oauth2Constant.APP_ID);
            }
            sysOplog.setAppid(appId);


            sysOplogService.save(sysOplog);

        } catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    /**
     * 是否存在注解，如果存在就获取
     * @param joinPoint
     * @return
     */
    private OpLog getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(OpLog.class);
        }
        return null;
    }


    private String getMachineName(HttpServletRequest request) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost(); // 获取本地IP地址
            return inetAddress.getHostName();
        }catch (Exception e){
            return "Administrator";
        }
    }
}
