package com.geoway.design.biz.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 配置文件类
 *
 * @author: wujing
 * @Date: 2021/11/11
 */
@Component
public class ProjectConfig {


    /**
     * 图片上传路径
     */
    @Value("${ImgConfig.saveDir}")
    private String imgSaveDir;

    /**
     * 图片存储地址
     */
    @Value("${ImgConfig.saveUrl}")
    private String imgSaveUrl;

    /**
     * 图片查询地址
     */
    @Value("${ImgConfig.accessUrl}")
    private String imgAccessUrl;

    /**
     * 单点登录开关
     */
    @Value("${sso.enable}")
    private String ssoEnable;

    /**
     * 单点登录session接管方式(local或redis)
     */
    @Value("${sso.session.manager}")
    private String ssoSessionManager;

    /**
     * 单点缓存失效时常(秒)
     */
    @Value("${sso.timeout}")
    private int ssoTimeout;

    /**
     * 统一单点登录地址
     */
    @Value("${sso.server.url}")
    private String ssoServerUrl;

    /**
     * 单点登录成功后回调接口地址(客户端提供)
     */
    @Value("${sso.app.loginApi}")
    private String ssoAppLoginApi;

    /**
     * 客户端继承时应用备案id
     */
    @Value("${sso.app.id}")
    private String ssoAppId;
    /**
     * 应用备案授权码
     */
    @Value("${sso.app.secret}")
    private String ssoAppSecret;

    @Value("${sso.setting.login-page}")
    private String loginPageType;

    public String getImgSaveDir() {
        return imgSaveDir;
    }

    public void setImgSaveDir(String imgSaveDir) {
        this.imgSaveDir = imgSaveDir;
    }

    public String getImgSaveUrl() {
        return imgSaveUrl;
    }

    public void setImgSaveUrl(String imgSaveUrl) {
        this.imgSaveUrl = imgSaveUrl;
    }

    public String getImgAccessUrl() {
        return imgAccessUrl;
    }

    public void setImgAccessUrl(String imgAccessUrl) {
        this.imgAccessUrl = imgAccessUrl;
    }

    public String getSsoEnable() {
        return ssoEnable;
    }

    public void setSsoEnable(String ssoEnable) {
        this.ssoEnable = ssoEnable;
    }

    public String getSsoSessionManager() {
        return ssoSessionManager;
    }

    public void setSsoSessionManager(String ssoSessionManager) {
        this.ssoSessionManager = ssoSessionManager;
    }

    public int getSsoTimeout() {
        if(ssoTimeout<=0){
            ssoTimeout=100*365*24*60*60;
        }
        return ssoTimeout;
    }

    public void setSsoTimeout(int ssoTimeout) {
        this.ssoTimeout = ssoTimeout;
    }

    public String getSsoServerUrl() {
        return ssoServerUrl;
    }

    public void setSsoServerUrl(String ssoServerUrl) {
        this.ssoServerUrl = ssoServerUrl;
    }

    public String getSsoAppLoginApi() {
        return ssoAppLoginApi;
    }

    public void setSsoAppLoginApi(String ssoAppLoginApi) {
        this.ssoAppLoginApi = ssoAppLoginApi;
    }

    public String getSsoAppId() {
        return ssoAppId;
    }

    public void setSsoAppId(String ssoAppId) {
        this.ssoAppId = ssoAppId;
    }

    public String getSsoAppSecret() {
        return ssoAppSecret;
    }

    public void setSsoAppSecret(String ssoAppSecret) {
        this.ssoAppSecret = ssoAppSecret;
    }

    public String getLoginPageType() {
        return loginPageType;
    }

    public void setLoginPageType(String loginPageType) {
        this.loginPageType = loginPageType;
    }
    /**
     * 数字广东
     */
    @Data
    @Component("DigitalGDConfig")
    public class DigitalGD{

        /**
         * 认证中心路径
         */
        @Value("${DigitalGD.uaa:http://172.16.32.23:33494/services/am-uaa/}")
        private String DigitalUaa;

        /**
         * 用户中心路径
         */
        @Value("${DigitalGD.usrc:http://172.16.32.23:33494/services/am-usrc/}")
        private String DigitalUsrc;

        /**
         * 应用秘钥
         */
        @Value("${DigitalGD.passId:gw-sksjglyfwzxt}")
        private String DigitalPassId;

        /**
         * 应用token
         */
        @Value("${DigitalGD.token:gw-sksjglyfwzxta052bd16e96e435b95ed50a6a6bd0f19}")
        private String DigitalToken;

        /**
         * Ras公钥
         */
        @Value("${DigitalGD.Rsa:MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBANL378k3RiZHWx5AfJqdH9xRNBmD9wGD2iRe41HdTNF8RUhNnHit5NpMNtGL0NPTSSpPjjI1kJfVorRvaQerUgkCAwEAAQ==}")
        private String DigitalToRsa;

        /**
         * Ras公钥
         */
        @Value("${DigitalGD.RsaSecret:}")
        private String DigitalToRsaSecret;

        /**
         * 网关passId
         */
        @Value("${DigitalGD.passIdTif:sksjglyfwzxt}")
        private String DigitalPassIdTif;

        /**
         * 网关token
         */
        @Value("${DigitalGD.tokenTif:mAD41Ff145lngKK2CDhcVFJLMirys8hc}")
        private String DigitalTokenTif;
    }

}
