package com.geoway.design.biz.dto;

import lombok.Data;

@Data
public class OneLoginRequestData {

    /**
     * SDK 返回的流水号， 一次有效
     */
    private String process_id;
    /**
     * 用户签名， 用于账号校验
     * 生成方式：
     * 1.将 app_id, 以及当前时间戳（ 毫秒为
     * 单位） 通过”&&”连接。（ app_id +‘ &&’
     * + timestamp）
     * 2.使用 app_key 进行 hmac-sha256 签
     * 名。 将结果转换为 16 进制。
     */
    private String sign;
    /**
     * SDK 返回的运营商 Token
     */
    private String token;

    /**
     * 当前时间（ 单位为毫秒）， sign 加密
     * 所使用的当前时间戳与其相同
     */
    private Long timestamp;
    /**
     * 授权码,电信新版本接口校验码， 仅电信手
     * 机号需此入参
     */
    private String authCode="";

}
