package com.geoway.design.biz.dto.uis;

import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 阿力
 * @desc UIS组织机构实体
 */
@Data
public class OrganizationDTO {

    /**
     * 机构ID
     */
    private String id;

    /**
     * 机构名称
     */
    private String name;

    /**
     * 机构编码
     */
    private String code;

    /**
     * 上级机构id
     */
    private String pid;

    /**
     * 机构状态
     */
    private Integer status;

    /**
     * 机构级别
     */
    private Integer level;

    /**
     * 机构负责人电话
     */
    private String phoneNumber;

    /**
     * 机构负责人邮箱
     */
    private String email;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 机构别名
     */
    private String text;

    /**
     * 机构图标
     */
    private String iconCls;

    /**
     * 下面的子机构
     */
    private List<OrganizationDTO> children = new ArrayList<OrganizationDTO>();

    /**
     * 行政区
     */
    private String regionIds;

    /**
     * 上级机构
     */
    private OrganizationDTO parentOrg;

    /**
     * 状态
     */
    private String state = "closed";

    /**
     * 行政区列表
     */
    private List<RegionDTO> regions;

    /**
     * 是否磨机机构
     */
    private boolean leaf = false;




}
