package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @TableName sys_menu
 */
@TableName(value ="sys_menu")
@Data
public class SysMenu implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 描述
     */
    @TableField(value = "f_describe")
    private String describe;

    /**
     * 链接地址
     */
    @TableField(value = "f_url")
    private String url;

    /**
     * 系统关键字
     */
    @TableField(value = "f_key")
    private String key;

    /**
     * 图片地址
     */
    @TableField(value = "f_imgurl")
    private String imgurl;

    /**
     * 上级id
     */
    @TableField(value = "f_pid")
    private String pid;

    /**
     * 排序
     */
    @TableField(value = "f_sort")
    private Integer sort;

    /**
     * 是否叶子节点  0.否 1.是
     */
    @TableField(value = "f_isleaf")
    private Integer isleaf;

    /**
     * 应用功能id
     */
    @TableField(value = "f_functionid")
    private String functionId;

    /**
     * 菜单类型 0.无  1.普通菜单 2.功能菜单
     */
    @TableField(value = "f_type")
    private Integer type;

    /**
     * 对应系统id
     */
    @TableField(value = "f_systemid")
    private String systemId;

    /**
     * 级别
     */
    @TableField(value = "f_level")
    private Integer level;

    /**
     * 0.否 1.是

     */
    @TableField(value = "f_isdefault")
    private Integer isdefault;

    /**
     * 
     */
    @TableField(value = "f_iscache")
    private Integer iscache;

    /**
     * 功能类型 1.挂接功能模块 2.挂接系统
     */
    @TableField(value = "f_funtype")
    private Integer funtype;

    /**
     * 
     */
    @TableField(value = "f_imageid")
    private String imageId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


    @TableField(value = "f_group")
    private Integer group;

    @TableField(value = "f_open")
    private Integer open;

    @TableField(value = "f_otherstyle")
    private String otherStyle;

    @TableField(exist = false)
    private List<SysMenu> children;

    @TableField(exist = false)
    private SysFunction functionInfo;

    /**
     * 根节点
     */
    @TableField(exist = false)
    private String rootId;

    /**
     * 图标base64
     */
    @TableField(value = "f_icon")
    private String icon;

    /**
     * 激活图标base64
     */
    @TableField(value = "f_activeicon")
    private String activeIcon;

    /**
     * 图标默认颜色
     */
    @TableField(value = "f_iconcolor")
    private String iconColor;

    /**
     * 图标激活颜色
     */
    @TableField(value = "f_activecolor")
    private String activeColor;

    /**
     * 图标位置
     */
    @TableField(value = "f_iconsite")
    private String iconSite;

    /**
     * 其他参数
     */
    @TableField(value = "f_params")
    private String params;

    @Override
    public boolean equals(Object obj) {

        SysMenu menu = (SysMenu) obj;
        return this.id == menu.id;
    }

}