package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 系统
 * @author: wujing
 * @Date: 2021/11/15
 */
@Data
@NoArgsConstructor
@TableName(value = "sys_system_ns")
public class SysNsSystem {

    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    @TableField(value = "f_name")
    private String name;

    @TableField(value = "f_key")
    private String key;

    @TableField(value = "f_state")
    private Integer state;

    @TableField(value = "f_imgurl")
    private String imgUrl;

    @TableField(value = "f_describe")
    private String describe;

    @TableField(value = "f_sort")
    private Integer sort;

    @TableField(value = "f_url")
    private String url;

    @TableField(value = "f_styleid")
    private String styleId;

    @TableField(value = "f_appsercet")
    private String appSercet;

    @TableField(value = "f_appkey")
    private String appKey;

    @TableField(value = "f_logintype")
    private String loginType;

    @TableField(value = "f_updatetime",fill = FieldFill.UPDATE)
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date upDateTime;

    @TableField(value = "f_logid")
    private String logoid;

    @TableField(value = "f_bgid")
    private String bgid;

    @TableField(value = "f_shownav")
    private Integer showNav;

    @TableField(value = "f_showmenu")
    private Integer showMenu;

    @TableField(value = "f_showuser")
    private Integer showUser;

    @TableField(value = "f_icon")
    private String icon;

    @TableField(value = "f_groupid")
    private String groupId;

    @TableField(value = "f_showhomeback")
    private Integer showHomeBack;

    @TableField(value = "f_homelink")
    private String homeLink;

    @TableField(value = "f_hidelogo")
    private Integer hidelogo = 0;

    @TableField(value = "f_showexit")
    private Integer showExit;

    @TableField(value = "f_exitlink")
    private String exitLink;

    @TableField(value = "f_params")
    private String params;

    @TableField(exist = false)
    private List<SysMenu> sysMenu;

    @TableField(exist = false)
    private List<SysMenu> uCenterMenu;



}
