package com.geoway.design.biz.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName sys_oplog
 */
@TableName(value ="sys_oplog")
@NoArgsConstructor
@Data
public class SysOplog implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 
     */
    @Excel(name = "名称", orderNum = "1")
    @TableField(value = "f_name")
    private String name;

    /**
     * 
     */
    @Excel(name = "详情", orderNum = "2")
    @TableField(value = "f_detail")
    private String detail;

    /**
     * 
     */
    @Excel(name = "参数", orderNum = "3")
    @TableField(value = "f_param")
    @JsonIgnore
    private String param;

    /**
     * 
     */
    @Excel(name = "用户id", orderNum = "4")
    @TableField(value = "f_userid")
    private String userid;

    /**
     * 
     */
    @Excel(name = "用户名", orderNum = "5")
    @TableField(value = "f_username")
    private String username;

    /**
     * 
     */
    @Excel(name = "ip", orderNum = "6")
    @TableField(value = "f_ip")
    private String ip;

    /**
     * 
     */
    @Excel(name = "操作类型", orderNum = "7")
    @TableField(value = "f_optype")
    private String optype;

    /**
     * 
     */
    @Excel(name = "调用方法", orderNum = "8")
    @TableField(value = "f_method")
    @JsonIgnore
    private String method;    /**
     *
     */
    @Excel(name = "创建时间", orderNum = "9")
    @TableField(value = "f_createtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createtime;

    /**
     *
     */
    @Excel(name = "系统id", orderNum = "10")
    @TableField(value = "f_systemid")
    private String systemid;

    /**
     *
     */

    @Excel(name = "应用id", orderNum = "11")
    @TableField(value = "f_appid")
    private String appid;

    /**
     * 请求客户端的名称
     */
    @Excel(name = "客户端名称", orderNum = "12")
    @TableField(value = "f_machine_name")
    private String machineName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}