package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * @TableName sys_oplog_backup
 */
@TableName(value ="sys_oplog_backup")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SysOplogBackup implements Serializable {
    /**
     * id
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 备份名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 创建时间
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     * 备份日志的日期
     */
    @TableField(value = "f_date")
    private Date date;

    /**
     * 文件路径
     */
    @TableField(value = "f_path")
    private String path;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}