package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 应用关联的用户，只针对二级管理员
 * @TableName sys_user_application
 */
@TableName(value ="sys_user_application")
@Data
public class SysUserApplication implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id")
    private String id;

    /**
     * 用户id
     */
    @TableField(value = "f_userid")
    private String userid;

    /**
     * 应用id
     */
    @TableField(value = "f_appid")
    private String appid;

    /**
     * 应用类型： 1.系统  2.应用
     */
    @TableField(value = "f_apptype")
    private Integer apptype;

    /**
     * 类型（1.分组 2.子应用 ）
     */
    @TableField(value = "f_type")
    private Integer type;



    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}