package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @TableName sys_user_register
 */
@TableName(value = "sys_user_register")
@Data
public class SysUserRegister implements Serializable {

    /**
     *id
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     *人名
     */
    @TableField(value = "f_name")
    private String name;

    /**
     *账户名
     */
    @TableField(value = "f_accout")
    private String accout;

    @TableField(value="f_password")
    private String password;

    /**
     *电话
     */
    @TableField(value = "f_tel")
    private String tel;

    /**
     * 加密的手机号
     */
    @TableField(value = "f_tel_encrypt")
    private String telEncrypt;

    /**
     * 邮箱
     */
    @TableField(value = "f_email")
    private String email;

    /**
     * 创建时间
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     * 审核时间
     */
    @TableField(value = "f_audit_time")
    private Date auditTime;

    /**
     * 审核状态：0未审核，1通过，2不通过
     */
    @TableField(value = "f_audit_state")
    private String auditState;

    /**
     * 审核意见
     */
    @TableField(value = "f_audit_opinion")
    private String auditOpinion;

    /**
     * 审核人
     */
    @TableField(value = "f_audit_user")
    private String auditUser;

    @TableField(exist = false)
    private String auditUserName;

    /**
     * 机构
     */
    @TableField(value = "f_organization")
    private String organization;

    /**
     * 辖区
     */
    @TableField(value = "f_region")
    private String region;

    /**
     * 用户类别
     */
    @TableField(value = "f_kind")
    private Integer kind;

    @TableField(exist = false)
    private String orgNames;

    @TableField(exist = false)
    private String regionNames;
}