package com.geoway.design.biz.entity;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName sys_user_security
 */
@TableName(value ="sys_user_security")
@Data
public class SysUserSecurity implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id")
    private String id;

    /**
     * 
     */
    @TableField(value = "f_password")
    private String password;

    /**
     * 
     */
    @TableField(value = "f_salt")
    private String salt;

    /**
     * 
     */
    @TableField(value = "f_createtime",fill = FieldFill.INSERT)
    private Date createtime;

    /**
     * 
     */
    @TableField(value = "f_expiretime")
    private Date expiretime;

    /**
     * 
     */
    @TableField(value = "f_logintime")
    private Date logintime;

    /**
     * 
     */
    @TableField(value = "f_lock")
    private Integer lock = 0;

    /**
     * 
     */
    @TableField(value = "f_unlocktime")
    private Date unlocktime;

    /**
     * 
     */
    @TableField(value = "f_failedtimes")
    private Integer failedtimes = 0;

    /**
     * 
     */
    @TableField(value = "f_lastfailedtime")
    private Date lastfailedtime;


    /**
     * 重置密码
     */
    @TableField(value = "f_resetpassword")
    private String resetPassword;

    /**
     *
     */
    @TableField(value = "f_updatetime")
    private Date updatetime;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public void addOneFailureTimes() {
        //如果是同一天的话
        if(this.lastfailedtime!=null && DateUtil.isSameDay(this.lastfailedtime, new Date())){
            this.failedtimes++;
        }else{
            this.failedtimes = 0;
        }
    }

    public void unlock(){
        this.failedtimes = 0;
        this.lock = 0;
        this.unlocktime = null;
    }
    public void lock(int autoUnlockMinutes){
        this.lock = 1;
        long  autuoUnlockTimeMillis = System.currentTimeMillis() + autoUnlockMinutes * 60 * 1000;
        this.unlocktime = new Date(autuoUnlockTimeMillis);
    }
}