package com.geoway.design.biz.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.design.base.base.dto.BaseResponse;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author daidd
 * @desc 管理员登录Filter(用户移动APP 、 前后端分离的应用单点登录拦截)
 */
public class AdminLoginFilter implements Filter {

    private AccessTokenManager accessTokenManager;

    private List<String>  adminURLS = new ArrayList<>();

    public void setAdminURLS(List<String> adminURLS) {
        this.adminURLS = adminURLS;
    }

    public void setAccessTokenManager(AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        String reqUrl = httpRequest.getServletPath();
        if (matchUrls(reqUrl)) {
            HttpServletResponse httpResponse = (HttpServletResponse) response;
           if(!isAccessAllowed(httpRequest, httpResponse)){
               return;
           }

        }
        chain.doFilter(request, response);
    }

    protected boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        //处理跨域访问时的预请求
        //参考: https://segmentfault.com/q/1010000012364132
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(HttpServletResponse.SC_OK);
            return true;
        }
        String accessToken = CommonLoginUserUtil.getToken();
        //验证基于cookie的accessToken
        if (StrUtil.isEmpty(accessToken)) {
            markNoPermissionResponse(response);
            return false;
        }

        SsoUser ssoUser = null;
         AccessTokenContent accessTokenContent = accessTokenManager.get(accessToken);
        if(accessTokenContent != null){
            ssoUser =  accessTokenContent.getUser();
        }

        if(ssoUser == null || (ssoUser.getUserCatalog() != 1 && ssoUser.getUserCatalog() != 2 )){
            markNoPermissionResponse(response);
            return  false;
        }

        return true;
    }


    /**
     * @param url        当前请求url
     * @return 包含在中true, 否则false
     * @desc 匹配排除、包含url
     */
    private boolean matchUrls( String url) {
        if (adminURLS == null || adminURLS.size() == 0) {
            return false;
        }
        Map<Boolean, List<String>> map = adminURLS.stream().collect(Collectors.partitioningBy(u -> u.endsWith(SsoConstant.URL_FUZZY_MATCH)));
        //精准匹配
        List<String> urlList = map.get(false);
        for (String fullUrl : urlList) {
            if (fullUrl.trim().equals(url)) {
                return true;
            }
        }
        //模糊匹配
        urlList = map.get(true);
        // 再进行模糊匹配
        for (String matchUrl : urlList) {
            if (url.startsWith(matchUrl.trim().replace(SsoConstant.URL_FUZZY_MATCH, ""))) {
                return true;
            }
        }
        return false;
    }

    protected void markNoPermissionResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType(MediaType.APPLICATION_JSON_VALUE);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");

        BaseResponse baseResponse = new BaseResponse();
        baseResponse.markFailure();
        baseResponse.setMessage("该用户没有管理员权限");
        String jsonResult = JSON.toJSONString(baseResponse, SerializerFeature.WriteNullStringAsEmpty);
        response.getWriter().write(jsonResult);
    }

}