package com.geoway.design.biz.mapper;

import com.geoway.design.biz.entity.SysApplication;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 应用
 * @author: wujing
 * @Date: 2021/10/31
 */
@Mapper
@Component(value = "ApplicationSysMapper")
public interface ApplicationSysMapper extends MPJBaseMapper<SysApplication> {

    @Select("select * from sys_application t1 where not exists (select 1 from sys_application_group t2 where t2.f_appid = t1.f_id )")
    @Results(id = "appResultMap", value = {
            @Result(property = "id", column = "f_id"),
            @Result(property = "name", column = "f_name"),
            @Result(property = "describe", column = "f_describe"),
            @Result(property = "appId", column = "f_appid"),
            @Result(property = "version", column = "f_version"),
            @Result(property = "company", column = "f_company"),
            @Result(property = "sort", column = "f_sort"),
            @Result(property = "jsonInfo", column = "f_json"),
            @Result(property = "icon", column = "f_icon"),
            @Result(property = "imgUrl", column = "f_imgUrl"),
            @Result(property = "appSecret", column = "f_appsecret"),
            @Result(property = "url", column = "f_url"),
            @Result(property = "imgid", column = "f_imgid"),
            @Result(property = "open", column = "f_open"),
            @Result(property = "iscache", column = "f_iscache")
    })
    List<SysApplication> queryAppNoGroup();

    @Select("select * from sys_application t1 where  exists (select 1 from sys_application_group t2 where t2.f_appid = t1.f_id and t2.f_groupid = #{groupId})")
    @ResultMap("appResultMap")
    List<SysApplication> queryAppsByGroupId(@Param("groupId") String groupId);

}
