package com.geoway.design.biz.mapper;

import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.vo.SysUserVO;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author daidongdong
 * @description 针对表【sys_user】的数据库操作Mapper
 * @createDate 2021-12-20 17:06:21
 * @Entity com.geoway.ns.design.biz.entity.SysUser
 */
@Repository
public interface SysUserMapper extends MPJBaseMapper<SysUser> {

    /**
     * 查询组织机构关联用户
     *
     * @param name
     * @return
     */
    List<SysUser> queryUsersInOrg(String name);

    /**
     * 查询角色关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryRolerUsers(String roleId);

    /**
     * 查询组织机构关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryOrgUsers(String roleId);

    /**
     * 查询所有组织机构用户
     *
     * @return
     */
    List<SysUser> queryAllOrgUsers();

    /**
     * 得到系统用户签证官
     *
     * @param userId 用户id
     * @return {@link SysUserVO}
     */
    SysUserVO getSysUserVO(@Param("userId") String userId);

    /**
     * 查询无机构用户列表
     * @return
     */
    List<SysUser> queryAllNonOrgUsers();
}




