package com.geoway.design.biz.scheduled;

import com.geoway.design.biz.service.sys.SysOplogBackupService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 日志备份执行器
 *
 * @author by wangqiang
 * @date 2025/6/10.
 */
@Component
@ConditionalOnProperty(prefix = "scheduled.oplogBackup", name = "enabled", havingValue = "true")
public class LogBackupScheduled {
    @Resource
    private SysOplogBackupService sysOplogBackupService;

    /**
     * 日志按天导出为excel
     * 每天凌晨备份昨天的日志
     */
    @Scheduled(cron = "${scheduled.oplogBackup.cron}")
    public void backupYesterday() throws Exception {
        String dateStr = LocalDate.now().minusDays(1)
                .format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        sysOplogBackupService.backup(dateStr);
    }

}
