package com.geoway.design.biz.service.common.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.service.common.IGeneralService;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.*;


/**
 * 通用接口
 * @author: wujing
 * @Date: 2021/11/11
 */
@Service
public class GeneralServiceImpl implements IGeneralService {

    @Autowired
    private ProjectConfig projectConfig;

    @Autowired
    private IFunctionSysService functionSysService;

    @Override
    public Map<String,String> uploadImg(MultipartFile file, HttpServletRequest request) throws IOException {

        HashMap<String, String> map = new HashMap<>();
        File targetFile = null;
        //返回存储路径
        String url = "";
        //获取文件名加后缀
        String fileName = file.getOriginalFilename();
        if (fileName != null && fileName != "") {
            //文件存储位置
            String path = projectConfig.getImgSaveUrl() + projectConfig.getImgSaveDir();
            //访问的地址
            String access = projectConfig.getImgAccessUrl() + projectConfig.getImgSaveDir();
            //文件后缀
            String fileF = fileName.substring(fileName.lastIndexOf("."), fileName.length());
            //新的文件名
            fileName = System.currentTimeMillis() + "_" + new Random().nextInt(100) + fileF;
            //获取文件夹路径
            File file1 = new File(path);
            //如果文件夹不存在则创建
            if (!file1.exists()) {
                file1.mkdirs();
            }
            //将图片存入文件夹
            targetFile = new File(file1, fileName);
            //将上传的文件写到服务器上指定的文件。
            file.transferTo(targetFile);
            url = access + fileName;
        }
        map.put("imgUrl",url);
        map.put("saveUrl",projectConfig.getImgSaveDir()+fileName);
        return map;
    }

    @Override
    public void deleteImg() {
        //文件存储位置
        String path = projectConfig.getImgSaveUrl() + projectConfig.getImgSaveDir();
        //在使用的图片
        List<String> names = new ArrayList<>();
        //获取该图片名称
        List<SysFunction> list = functionSysService.list();
        for (SysFunction function: list  ) {
            if(StringUtils.isNotBlank( function.getImgUrl() )){
                names.add( function.getImgUrl() );
            }
        }

        //获取目录下所有的文件名
        List<String> fileNames = getFileNames(path);
        System.out.println("1");
    }

    private List<String> getFileNames(String path){
        List<String> names = new ArrayList<>();
        File file = new File(path);
        //判断是否文件夹
        if(file.isDirectory()){
            //获取所有文件
            File[] files = file.listFiles();
            for (File fileInfo :files ) {
                names.add( fileInfo.getName() );
            }
        }
        return names;
    }

}
