package com.geoway.design.biz.service.dev;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysUserOrganization;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_organization】的数据库操作Service
* @createDate 2021-12-20 17:11:24
*/
public interface IUserOrganizationService {

    /**
     * 更新用户关联组织
     * @param userId
     * @param orgIds
     */
     void updateUserOrg(String userId, List<String> orgIds);

    /**
     * 更新组织关联用户
     * @param orgId
     * @param userIds
     */
     void updateOrgUsers(String orgId, List<String> userIds);

    /**
     * 批量保存
     * @param userOrgs
     */
    void saveBatch( List<SysUserOrganization> userOrgs);

    /**
     * 保存
     * @param userOrg
     */
    void saveOne(SysUserOrganization userOrg);

    /**
     * 删除
     * @param orgId
     * @param userId
     */
    void removeByOrgUserId(String orgId, String userId);

    /**
     * 查询某个组织机构下所有的用户
     * @param orgId
     * @return
     */
    List<SysUserOrganization> queryByOrgId(String orgId);

    List<SysUserOrganization> queryList(String filterParam);


}
