package com.geoway.design.biz.service.dev;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.biz.entity.SysUser;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName IUserManagerService
 * @Description 用户管理
 * @date 2024/3/11 10:07
 * @Version 1.0
 */
public interface IUserService extends BaseUserSysService{

    /**
     * 用户是否同步模式
     * @return
     */
    Boolean isSync();

    /**
     * 保存与编辑
     * @param user 用户基本信息
     * @param photo  用户头像
     * @param deletePhoto 是否删除
     * @throws Exception
     */
    void saveOrUp(SysUser user, MultipartFile photo, boolean deletePhoto);

    /**
     * 批量保存
     * @param users
     * @throws Exception
     */

    void batchSave(List<SysUser> users);

    /**
     * 获取用户详情
     * @param userId
     * @return
     */
    SysUser query(String userId);

    /**
     * 获取多个用户的信息
     * @param userIds
     * @return
     */
    List<SysUser> query(List<String> userIds);

    /**
     * 根据过滤条件列表
     * @param filterParam
     * @return
     * @throws Exception
     */
    List<SysUser> queryList(String filterParam);
    /**
     * 根据过滤条件列表
     * @param filterParam
     * @return
     * @throws Exception
     */
    List<SysUser> queryList(String filterParam,boolean withRoleOrg);
    /**
     * 根据过滤条件查询用户个数
     * @param filterParam
     * @return
     * @throws Exception
     */
    int  queryCount(String filterParam);
    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysUser> queryPage(String filterParam, int page, int size);

    /**
     * 删除用户（附带删除用户关联的角色，组织等）
     * @param id
     */
    void delete(String id);
    /**
     * 批量删除
     *
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids);
    /**
     * 修改用户密码
     *
     * @param userId
     * @param oldPwd
     * @param newPwd
     */
    void changePassword(String userId, String oldPwd, String newPwd);

    /**
     * 直接修改用户密码，无需校验旧密码
     *
     * @param userId
     * @param password
     */
    void changePassword(String userId, String password);

    /**
     * 重置用户密码
     *
     * @param userId
     */
    String resetUserPassword(String userId);

    /**
     * 导出用户
     *
     * @param response
     */

    void exportUsers(String filterParam,Boolean isTemplate, HttpServletResponse response);

    /**
     *
     * @param userList
     * @param isUpdateSupport
     */
    String importUsers(List<SysUser> userList, Boolean isUpdateSupport);

}
