package com.geoway.design.biz.service.dev.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.dto.UserSyncDTO;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.service.dev.IUserSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @author 连世忠
 * @ClassName AbstractUserSyncService
 * @Description TODO
 * @date 2024/3/15 10:08
 * @Version 1.0
 */
public abstract class AbstractUserSyncService implements IUserSyncService {
    @Autowired
    @Qualifier("localUserServiceImpl")
    protected LocalUserServiceImpl localUserService;
    @Autowired
    protected LocalUserOrganizationServiceImpl localUserOrganizationService;
    @Autowired
    protected LocalOrganizationServiceImpl localOrganizationService;
    @Override
    public abstract UserSyncDTO getUserInfo();

    @Override
    public String syncUserInfo(UserSyncDTO userInfo) {
        if(userInfo==null){
            return "无用户信息需要同步！";
        }
        int userNumber=0;
        if(userInfo.getUsers()!=null) {
            userNumber=userInfo.getUsers().size();
            localUserService.saveOrUpdateBatch(userInfo.getUsers());
        }
        int orgNumber=0;
        if(userInfo.getOrgs()!=null) {
            orgNumber=userInfo.getOrgs().size();
            localOrganizationService.saveOrUpdateBatch(userInfo.getOrgs());
        }
        int userOrgs=0;
        if(userInfo.getUserOrgs()!=null) {
            userOrgs=userInfo.getUserOrgs().size();
            localUserOrganizationService.saveOrUpdateBatch(userInfo.getUserOrgs());
        }
        return String.format("总共同步了：%s个用户,%个组织机构，%个用户-组织机构关系",userNumber,orgNumber,userOrgs);
    }
}
