package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysUserOrganization;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.mapper.SysUserOrganizationMapper;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_organization】的数据库操作Service实现
* @createDate 2021-12-20 17:11:24
*/
@Service
public class LocalUserOrganizationServiceImpl extends ServiceImpl<SysUserOrganizationMapper, SysUserOrganization>  implements IUserOrganizationService {

    @Autowired
    private SysUserOrganizationMapper sysUserOrganizationMapper;
    @Override
    @OpLog(name = "修改用户所属组织", opType = OpLog.OpType.update)
    public void updateUserOrg(String userId, List<String> orgIds) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserOrganization> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getUserid,userId);

        //先移除
        this.sysUserOrganizationMapper.delete(wrapper);
        if(orgIds == null){
            return;
        }
        List<SysUserOrganization> userOrgs = new ArrayList<>();
        for(String orgId: orgIds){
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);

            userOrgs.add(userOrg);
        }
        if(userOrgs.size() > 0){
            for(SysUserOrganization userOrg:userOrgs){
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }
    }

    @Override
    public void updateOrgUsers(String orgId, List<String> userIds) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserOrganization> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid,orgId);

        //先移除
        this.sysUserOrganizationMapper.delete(wrapper);
        List<SysUserOrganization> userOrgs = new ArrayList<>();
        for(String userId: userIds){
            SysUserOrganization userOrg = new SysUserOrganization();
            userOrg.setUserid(userId);
            userOrg.setOrgid(orgId);

            userOrgs.add(userOrg);
        }
        if(userOrgs.size() > 0){
            for(SysUserOrganization userOrg:userOrgs){
                this.sysUserOrganizationMapper.insert(userOrg);
            }
        }

    }

    @Override
    public void saveBatch(List<SysUserOrganization> userOrgs) {
        super.saveBatch(userOrgs);
    }

    @Override
    public void saveOne(SysUserOrganization userOrg) {
        this.sysUserOrganizationMapper.insert(userOrg);
    }

    @Override
    public void removeByOrgUserId(String orgId,String userId) {
        LambdaQueryWrapper<SysUserOrganization> wrapper = Wrappers.lambdaQuery();
        if(StrUtil.isNotEmpty(orgId)){
        wrapper.eq(SysUserOrganization::getOrgid, orgId);
        }
        if(StrUtil.isNotEmpty(userId)){
            wrapper.eq(SysUserOrganization::getUserid, userId);
        }
        sysUserOrganizationMapper.delete(wrapper);
    }

    @Override
    public List<SysUserOrganization> queryByOrgId(String orgId) {
        LambdaQueryWrapper<SysUserOrganization> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserOrganization::getOrgid,orgId);
        return this.sysUserOrganizationMapper.selectList(wrapper);
    }

    @Override
    public List<SysUserOrganization> queryList(String filterParam) {
        try {
            MyBatisQueryMapperUtils<SysApplication> qmu = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysPermission.class);
            return this.sysUserOrganizationMapper.selectList(queryWrapper);
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }
    }
}




