package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.base.enums.UserSysEnum;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.ExcelUtil;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.base.support.encryption.Md5Utils;
import com.geoway.design.base.support.query.MPJQueryMapperUtil;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.mapper.*;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.sys.*;
import com.geoway.design.biz.util.PasswordUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName
 * @Description 本地用户管理
 * @date 2024/3/11 11:44
 * @Version 1.0
 */
@Slf4j
@Service
public class LocalUserServiceImpl extends ServiceImpl<SysUserMapper, SysUser> implements IUserService {

    @Autowired
    private ISysUserRoleService sysUserRoleService;

    @Autowired
    private IUserOrganizationService sysUserOrganizationService;

    @Autowired
    private ISysUserRegionService sysUserRegionService;

    @Autowired
    private SysRoleMapper sysRoleMapper;

    @Autowired
    private SysOrganizationMapper sysOrganizationMapper;

    @Autowired
    private SysRegionMapper sysRegionMapper;

    @Autowired
    private IOrganizationService organizationService;

    @Autowired
    private IFunctionSysService.ISysUserSecurityService sysUserSecurityService;

    @Autowired
    private IApplicationSysService.ISysImageService sysImageService;

    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Autowired
    private SysUserRegisterMapper sysUserRegisterMapper;

    @Autowired
    private SysUserLimitMapper sysUserLimitMapper;

    @Value("${password.initPassword:123456}")
    private String initPassword;

    @Value("${password.randomPassword:false}")
    private boolean isRandomPassword;

    @Value("${password.encryptMethod:MD5}")
    private String encryptMethod;

    @Value("${userTel.encrypt:true}")
    private boolean userTelEncrypt;

    @Autowired
    private ISysUserRegisterService userRegisterService;

    @Override
    public String getUserSys() {
        return UserSysEnum.JCKJ.value;
    }

    @Override
    public Boolean isSync() {
        return false;
    }

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            saveUserBaseInfo(user, file, deletePhoto);
            saveUserRelInfo(user);
        } catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void saveUserRelInfo(SysUser user) {
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank(otherParams)) {
            try {
                UserRelParams userParams = JSON.parseObject(otherParams, UserRelParams.class);
                sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
                sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
                sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
            } catch (Exception ex) {
                throw new ServiceException("错误:" + ex.getMessage());
            }
//            UserRelParams userParams = JSON.parseObject(otherParams, UserRelParams.class);
//            if (userParams.getRoles() != null && userParams.getRoles().size() > 0) {
//                sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
//            }
//            if (userParams.getOrganizations() != null && userParams.getOrganizations().size() > 0) {
//                sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
//            }

//            if (userParams.getRegions() != null && userParams.getRegions().size() > 0) {
//                sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
//            }
        }
    }

    protected void saveUserBaseInfo(SysUser user, MultipartFile file, boolean deletePhoto) {
        try {
            boolean isAdd = false;  //是否新增
            if (StrUtil.isBlank(user.getName())) {
                throw new RuntimeException("用户名不能为空");
            }

            String tel = user.getTel();
            if (StrUtil.isBlank(tel)) {
                throw new RuntimeException("手机号不能为空");
            }
            if (tel.length() != 11) {
                throw new RuntimeException("手机号格式错误");
            }

            // 手机号隐藏中间4位
            if (userTelEncrypt) {
                user.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));
            }

            //判断名称和账号是否重复
            LambdaQueryWrapper<SysUser> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUser::getAccout, user.getAccout());
            //有id就是更新
            if (StrUtil.isBlank(user.getId())) {
                wrapper.eq(SysUser::getSource, user.getSource());
                isAdd = true;
                user.setCreatetime(new Date());
                // 手机号加密
                if (userTelEncrypt && StrUtil.isBlank(user.getTelEncrypt())) {
                    user.setTelEncrypt(AESUtils.encrypt(tel, AESUtils.KEY));
                }
            } else {
                // 更新
                SysUser old = this.sysUserMapper.selectById(user.getId());
                wrapper.ne(SysUser::getId, user.getId());
                wrapper.eq(SysUser::getSource, old.getSource());
                if (old != null) {
                    user.setCreatetime(old.getCreatetime());
                    user.setUpdatetime(new Date());
                    user.setSource(old.getSource());
                    if (userTelEncrypt) {
                        if (tel.contains("*")) {
                            // 带星号的必须和旧的一致
                            if (!tel.equals(old.getTel())) {
                                throw new RuntimeException("手机号格式错误");
                            }
                        } else {
                            // 可以重填完整手机号
                            user.setTelEncrypt(AESUtils.encrypt(tel, AESUtils.KEY));
                        }
                    }
                }
            }
            //新增: 检查账号是否重复，更新时不用
            int iCount = this.sysUserMapper.selectCount(wrapper);
            if (iCount > 0) {
                throw new RuntimeException("账户:" + user.getAccout() + "  已存在！");
            }
            if (StrUtil.isBlank(user.getAname())) {
                user.setAname(user.getName());
            }

            if (!isAdd && deletePhoto) {
                sysImageService.removeById(user.getImgid());
                user.setImgid("");
            }
            if (isAdd) {
                this.sysUserMapper.insert(user);
            } else {
                this.sysUserMapper.updateById(user);
            }
            if (file != null && !file.isEmpty()) {

                SysImage sysImage = sysImageService.getById(user.getImgid());
                if (sysImage == null) {
                    sysImage = new SysImage();
                    sysImage.setObjectid(user.getId());
                    sysImage.setType(3);
                }

                sysImage.setImage(file.getBytes());
                sysImageService.saveOrUpdate(sysImage);
                LambdaUpdateWrapper<SysUser> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(SysUser::getImgid, sysImage.getId());
                updateWrapper.eq(SysUser::getId, user.getId());
                this.sysUserMapper.update(null, updateWrapper);
            }


            if (isAdd) {
                //设置密码和复位密码
                String password, resetPassword = "";
                if (StrUtil.isNotBlank(user.getPassword())) {
                    // 注册或导入的用户，带了合规的md5密码，不设复位密码，可直接登录
                    password = user.getPassword();
                } else {
                    // 设置初始密码和复位密码
                    resetPassword = initPassword;
                    if (isRandomPassword) {
                        resetPassword = getRandomPassword();
                    }
                    // 库里始终存md5密码
                   password = Md5Utils.getMD5Str(resetPassword, "UTF-8");
                }

                this.setPassword(user.getId(), password, resetPassword);
            }
        } catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void batchSave(List<SysUser> users) {
        for (SysUser user : users) {
            this.saveOrUp(user, null, false);
        }
    }

    @Override
    public SysUser query(String userId) {
        SysUser sysUser= this.sysUserMapper.selectById(userId);
        this.wrapperRoleAllNames(Collections.singletonList(sysUser));
        this.wrapperOrgAllNames(Collections.singletonList(sysUser));
        this.wrapperRegionAllNames(Collections.singletonList(sysUser));
        return sysUser;
    }

    @Override
    public List<SysUser> query(List<String> userIds) {
        List<SysUser> restult = new ArrayList<>();
        if (userIds.isEmpty()) {
            return restult;
        }
        List<List<String>> idGroups = Lists.partition(userIds, 10000);
        for (List<String> ids : idGroups) {
            restult.addAll(this.sysUserMapper.selectBatchIds(ids));
        }
        return restult;
    }

    @Override
    public List<SysUser> queryList(String filterParam) {
        return queryList(filterParam, true);
    }

    @Override
    public List<SysUser> queryList(String filterParam, boolean withRoleOrg) {
        try {
            MyBatisQueryMapperUtils<SysUser> qmu = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            queryWrapper.orderByDesc("f_createtime");
            //queryWrapper.orderByAsc("f_name");
            List<SysUser> users = this.sysUserMapper.selectList(queryWrapper);
            if (withRoleOrg) {
                this.wrapperRoleAllNames(users);
                this.wrapperOrgAllNames(users);
            }
            return users;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int queryCount(String filterParam) {
        try {
            MyBatisQueryMapperUtils<SysUser> qmu = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            return this.sysUserMapper.selectCount(queryWrapper);
        } catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size) {
        try {
            // 将电话tel参数转为加密参数
            filterParam = convertTelParam(filterParam);

            MPJQueryMapperUtil<SysUser> qmu = new MPJQueryMapperUtil<>();
            MPJLambdaWrapper<SysUser> queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            queryWrapper.leftJoin(SysUserSecurity.class, "sus", SysUserSecurity::getId, SysUser::getId);
            queryWrapper.selectAll(SysUser.class);
            queryWrapper.selectAs("sus", SysUserSecurity::getResetPassword, SysUser::getResetPassword);


            //超级管理员不显示
            //queryWrapper.ne(SysUser::getCatalog,1);
            queryWrapper.orderByDesc(SysUser::getCreatetime);
            queryWrapper.orderByAsc(SysUser::getName);


            Page<SysUser> pages = new Page<>(page, size);

            IPage<SysUser> pageUsers = this.sysUserMapper.selectPage(pages, queryWrapper);
            List<SysUser> users = pageUsers.getRecords();
            this.wrapperRoleAllNames(users);
            this.wrapperOrgAllNames(users);
            this.wrapperRegionAllNames(users);

            return pageUsers;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String convertTelParam(String filterParam) throws Exception {
        if (StrUtil.isBlank(filterParam)) return filterParam;
        if (!userTelEncrypt) return filterParam;
        String telStr = "tel_EQ_";
        String telEncryptStr = "telEncrypt_EQ_";
        if (!filterParam.contains(telStr)) return filterParam;
        int index = filterParam.indexOf(telStr);
        String sub1 = filterParam.substring(index);
        int i1 = sub1.indexOf(";");
        int i2 = sub1.indexOf(")");
        String sub2 = sub1;
        if (i1 > 0 || i2 > 0) {
            if (i1 > 0 && i2 > 0) {
                sub2 = sub1.substring(0, Math.min(i1, i2));
            } else {
                sub2 = sub1.substring(0, Math.max(i1, i2));
            }
        }
        String telValue = sub2.replace(telStr, "");
        String encryptValue = AESUtils.encrypt(telValue, AESUtils.KEY);
        return filterParam.replace(sub2, telEncryptStr + encryptValue);
    }

    @Override
    public void delete(String id) {

        if (StringUtils.isEmpty(id)) {
            throw new RuntimeException("传递的【id】为空！");
        }

        SysUser sysUser = this.sysUserMapper.selectById(id);
        //删除用户关联的角色
        LambdaQueryWrapper<SysUserRole> uerRoleWarpper = Wrappers.lambdaQuery();
        uerRoleWarpper.eq(SysUserRole::getUserid, id);

        sysUserRoleService.remove(uerRoleWarpper);


        //删除用户关联的组织
        sysUserOrganizationService.removeByOrgUserId("", id);

        //删除用户关联的区域
        LambdaQueryWrapper<SysUserRegion> uerRegionWarpper = Wrappers.lambdaQuery();
        uerRegionWarpper.eq(SysUserRegion::getUserid, id);

        sysUserRegionService.remove(uerRegionWarpper);

        //删除用户
        this.sysUserMapper.deleteById(id);
        sysUserSecurityService.removeById(id);

        //删除用户照片
        if (StrUtil.isNotBlank(sysUser.getImgid())) {
            sysImageService.removeById(sysUser.getImgid());
        }

        //删除注册信息（可以再次注册）
        sysUserRegisterMapper.delete(Wrappers.lambdaQuery(SysUserRegister.class)
                .eq(SysUserRegister::getName,sysUser.getName()));

        //删除黑名单
        LambdaQueryWrapper<SysUserLimit> uerLimitWarpper = Wrappers.lambdaQuery();
        uerLimitWarpper.eq(SysUserLimit::getUserid,id);

        sysUserLimitMapper.delete(uerLimitWarpper);

    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.delete(id);
        }
    }


    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        try {
            MyBatisQueryMapperUtils<SysUser> qmu = new MyBatisQueryMapperUtils<>();
            QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUser.class);
            List<SysUser> users = new ArrayList<>();
            queryWrapper.orderByAsc("f_name");
            if (isTemplate != true) {
                users = this.sysUserMapper.selectList(queryWrapper);
            }
            ExcelUtil.exportExcel(users, null, "用户列表", SysUser.class, "导出用户信息", true, response);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 用户Excel批量导入
     *
     * @param userList        用户列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     * @throws Exception
     */
    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        try {
            if (StringUtils.isNull(userList) || userList.size() == 0) {
                throw new ServiceException("导入用户数据不能为空！");
            }
            int successNum = 0;   //成功导入用户记录数
            int failureNum = 0;   //导入失败记录数
            StringBuilder successMsg = new StringBuilder();
            StringBuilder failureMsg = new StringBuilder();
            Date now = new Date();
            for (SysUser user : userList) {
                try {
                    LambdaQueryWrapper<SysUser> wrapper = Wrappers.lambdaQuery();
                    wrapper.eq(SysUser::getAccout, user.getAccout());
                    SysUser oldUser = this.sysUserMapper.selectOne(wrapper);
                    if (ObjectUtil.isNull(oldUser)) {
                        //没有此用户，直接导入
                        this.saveExcelUser(user);
                        successNum++;
                        successMsg.append("<br/>" + successNum + "、账号 " + user.getName() + " 导入成功");
                    } else if (isUpdateSupport) {
                        user.setId(oldUser.getId());
                        this.saveExcelUser(user);
                        successNum++;
                        successMsg.append("<br/>" + successNum + "、账号 " + user.getName() + " 更新成功");
                    } else {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、账号 " + user.getName() + " 已存在");
                    }
                } catch (Exception ex) {
                    failureNum++;
                    String msg = "<br/>" + failureNum + "、账号 " + user.getName() + " 导入失败：";
                    failureMsg.append(msg + ex.getMessage());
                    log.error(msg, ex);
                }
            }
            if (failureNum > 0) {
                failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
                throw new ServiceException(failureMsg.toString());
            } else {
                successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条，数据如下：");
            }
            return successMsg.toString();
        } catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        SysUserSecurity userSecurity = sysUserSecurityMapper.selectById(userId);
        if (userSecurity == null) {
            throw new RuntimeException("未查询到用户安全信息");
        }
        if (!userSecurity.getPassword().equals(passwordUtil.getMD5Password(oldPwd))) {
            throw new RuntimeException("用户原密码错误，请输入正确的原密码");
        }

        if (userSecurity.getPassword().equals(passwordUtil.getMD5Password(newPwd))) {
            throw new RuntimeException("新密码和原密码不能相同");
        }
        userSecurity.setResetPassword("");
        userSecurity.setPassword(passwordUtil.getMD5Password(newPwd));
        sysUserSecurityMapper.updateById(userSecurity);
    }

    @Override
    public void changePassword(String userId, String password) {
        SysUserSecurity sysUserSecurity = sysUserSecurityService.getById(userId);
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(passwordUtil.getMD5Password(password));
        sysUserSecurityService.saveOrUpdate(sysUserSecurity);
    }

    @Override
    public String resetUserPassword(String userId) {
        SysUserSecurity sysUserSecurity = sysUserSecurityService.getById(userId);
        if (sysUserSecurity == null) {
            throw new RuntimeException("该用户不支持密码重置");
            //sysUserSecurity = new SysUserSecurity();
            //sysUserSecurity.setId(userId);
        }
        String resetPassword = getRandomPassword();
        String password = Md5Utils.getMD5Str(resetPassword, "UTF-8");

        sysUserSecurity.setResetPassword(resetPassword);
        sysUserSecurity.setPassword(password);

        sysUserSecurityService.saveOrUpdate(sysUserSecurity);
        return resetPassword;
    }

    private String entryPassword(String password) {
        String entryPassword = password;

        if (encryptMethod.equalsIgnoreCase("MD5")) {
            entryPassword = Md5Utils.getMD5Str(password, "UTF-8");
        } else {
            try {
                entryPassword = AESUtils.encrypt(password, AESUtils.KEY);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return entryPassword;
    }

    private void setPassword(String userId, String password, String resetPassword) {
        SysUserSecurity sysUserSecurity = sysUserSecurityService.getById(userId);
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
        }
        sysUserSecurity.setPassword(password);
        sysUserSecurity.setResetPassword(resetPassword);
        sysUserSecurityService.saveOrUpdate(sysUserSecurity);
    }

    private void saveExcelUser(SysUser sysUser) {
        try {
            this.saveOrUp(sysUser, null, false); //保存用户
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void wrapperRoleAllNames(List<SysUser> users) {
        Map<String, String> allNameCache = new HashMap<>();
        for (SysUser user : users) {
            List<SysRole> roles = sysRoleMapper.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoleNames(roleAllNames);
            user.setRoles(roles);
        }
    }

    private void wrapperOrgAllNames(List<SysUser> users) {
        for (SysUser user : users) {
            List<String> orgAllNames = new ArrayList<>();

            List<SysOrganization> orgs = sysOrganizationMapper.queryUserOrgs(user.getId());
            for (SysOrganization org : orgs) {
                List<SysOrganization> parentOrg = organizationService.queryAllParentOrg(org.getId());
                orgAllNames.add(StrUtil.join("/", parentOrg.stream().map(SysOrganization::getName).collect(Collectors.toList())));
            }
            user.setOrgNames(orgAllNames);
            user.setOrganizations(orgs);
        }
    }

    private void wrapperRegionAllNames(List<SysUser> users) {
        for (SysUser user : users) {
            List<String> allRegionNames = new ArrayList<>();

            List<SysRegion> regions = sysRegionMapper.queryUserRegions(user.getId());
            for (SysRegion region : regions) {
                List<SysRegion> parentRegion = sysRegionMapper.getAllParentRegion(region.getCode());
                Collections.reverse(parentRegion);
                allRegionNames.add(StrUtil.join("/", parentRegion.stream().map(SysRegion::getName).collect(Collectors.toList())));
            }
            user.setRegionNames(allRegionNames);
            user.setRegions(regions);
        }
    }

    private String getRandomPassword() {

        //密码规则
        //大写字母A-Z（去掉O、L、I）
        //小写字母a-z（去掉o、l）
        //数字2-9（去掉0和1）
        //几个特殊符号@#（去掉&%）

        final char[] UPPERCASE = "ABCDEFGHJKMNPQRSTUVWXYZ".toCharArray();
        char[] LOWERCASE = "abcdefghijkmnpqrstuvwxyz".toCharArray();
        char[] NUMBERS = "23456789".toCharArray();
        char[] SPECIALS = "@#".toCharArray();

        Random random = new Random();
        List<Character> password = new ArrayList<>();

        // 添加1个大写字母
        password.add(UPPERCASE[random.nextInt(UPPERCASE.length)]);
        // 添加3个小写字母
        for (int i = 0; i < 3; i++) {
            password.add(LOWERCASE[random.nextInt(LOWERCASE.length)]);
        }
        // 添加3个数字
        for (int i = 0; i < 3; i++) {
            password.add(NUMBERS[random.nextInt(NUMBERS.length)]);
        }
        // 添加1个特殊符号
        password.add(SPECIALS[random.nextInt(SPECIALS.length)]);
        // 随机打乱顺序
        Collections.shuffle(password);
        // 转换为字符串
        StringBuilder sb = new StringBuilder();
        for (char c : password) {
            sb.append(c);
        }

        return sb.toString();


       /* Random random = new Random();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(getRandomCharter(random, true));
        strBuf.append(getRandomCharter(random, false));
        strBuf.append(getRandomCharter(random, false));
        strBuf.append(getRandomCharter(random, false));

        strBuf.append(getSpeCharter(random));

        strBuf.append(random.nextInt(9));
        strBuf.append(random.nextInt(9));
        strBuf.append(random.nextInt(9));

         return strBuf.toString();
      */


    }

    private String getRandomCharter(Random random, boolean upperCase) {
        int randomIndex = random.nextInt(26);
        char aa = upperCase ? 'A' : 'a';
        char randomChar = (char) (randomIndex + aa);

        return String.valueOf(randomChar);
    }

    private String getSpeCharter(Random random) {
        int randomIndex = random.nextInt(3);
        String[] secordArr = {"@", "#", "$", "!"};
        return secordArr[randomIndex];
    }
}
